/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.Optional;
import lombok.NonNull;

public final class PousseCafeDocGenerationConfiguration {
    @NonNull
    private final String domainName;
    @NonNull
    private final String version;
    @NonNull
    private final String outputDirectory;
    private final boolean includeGenerationDate;
    private final Optional<String> customDotExecutable;
    private final Optional<String> customFdpExecutable;
    @NonNull
    private final String pdfFileName;
    private final boolean debug;

    private static Optional<String> $default$customDotExecutable() {
        return Optional.empty();
    }

    private static Optional<String> $default$customFdpExecutable() {
        return Optional.empty();
    }

    PousseCafeDocGenerationConfiguration(@NonNull String domainName, @NonNull String version, @NonNull String outputDirectory, boolean includeGenerationDate, Optional<String> customDotExecutable, Optional<String> customFdpExecutable, @NonNull String pdfFileName, boolean debug) {
        if (domainName == null) {
            throw new NullPointerException("domainName is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (outputDirectory == null) {
            throw new NullPointerException("outputDirectory is marked non-null but is null");
        }
        if (pdfFileName == null) {
            throw new NullPointerException("pdfFileName is marked non-null but is null");
        }
        this.domainName = domainName;
        this.version = version;
        this.outputDirectory = outputDirectory;
        this.includeGenerationDate = includeGenerationDate;
        this.customDotExecutable = customDotExecutable;
        this.customFdpExecutable = customFdpExecutable;
        this.pdfFileName = pdfFileName;
        this.debug = debug;
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public String domainName() {
        return this.domainName;
    }

    @NonNull
    public String version() {
        return this.version;
    }

    @NonNull
    public String outputDirectory() {
        return this.outputDirectory;
    }

    public boolean includeGenerationDate() {
        return this.includeGenerationDate;
    }

    public Optional<String> customDotExecutable() {
        return this.customDotExecutable;
    }

    public Optional<String> customFdpExecutable() {
        return this.customFdpExecutable;
    }

    @NonNull
    public String pdfFileName() {
        return this.pdfFileName;
    }

    public boolean debug() {
        return this.debug;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PousseCafeDocGenerationConfiguration)) {
            return false;
        }
        PousseCafeDocGenerationConfiguration other = (PousseCafeDocGenerationConfiguration)o;
        if (this.includeGenerationDate() != other.includeGenerationDate()) {
            return false;
        }
        if (this.debug() != other.debug()) {
            return false;
        }
        String this$domainName = this.domainName();
        String other$domainName = other.domainName();
        if (this$domainName == null ? other$domainName != null : !this$domainName.equals(other$domainName)) {
            return false;
        }
        String this$version = this.version();
        String other$version = other.version();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$outputDirectory = this.outputDirectory();
        String other$outputDirectory = other.outputDirectory();
        if (this$outputDirectory == null ? other$outputDirectory != null : !this$outputDirectory.equals(other$outputDirectory)) {
            return false;
        }
        Optional<String> this$customDotExecutable = this.customDotExecutable();
        Optional<String> other$customDotExecutable = other.customDotExecutable();
        if (this$customDotExecutable == null ? other$customDotExecutable != null : !((Object)this$customDotExecutable).equals(other$customDotExecutable)) {
            return false;
        }
        Optional<String> this$customFdpExecutable = this.customFdpExecutable();
        Optional<String> other$customFdpExecutable = other.customFdpExecutable();
        if (this$customFdpExecutable == null ? other$customFdpExecutable != null : !((Object)this$customFdpExecutable).equals(other$customFdpExecutable)) {
            return false;
        }
        String this$pdfFileName = this.pdfFileName();
        String other$pdfFileName = other.pdfFileName();
        return !(this$pdfFileName == null ? other$pdfFileName != null : !this$pdfFileName.equals(other$pdfFileName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.includeGenerationDate() ? 79 : 97);
        result = result * 59 + (this.debug() ? 79 : 97);
        String $domainName = this.domainName();
        result = result * 59 + ($domainName == null ? 43 : $domainName.hashCode());
        String $version = this.version();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $outputDirectory = this.outputDirectory();
        result = result * 59 + ($outputDirectory == null ? 43 : $outputDirectory.hashCode());
        Optional<String> $customDotExecutable = this.customDotExecutable();
        result = result * 59 + ($customDotExecutable == null ? 43 : ((Object)$customDotExecutable).hashCode());
        Optional<String> $customFdpExecutable = this.customFdpExecutable();
        result = result * 59 + ($customFdpExecutable == null ? 43 : ((Object)$customFdpExecutable).hashCode());
        String $pdfFileName = this.pdfFileName();
        result = result * 59 + ($pdfFileName == null ? 43 : $pdfFileName.hashCode());
        return result;
    }

    public String toString() {
        return "PousseCafeDocGenerationConfiguration(domainName=" + this.domainName() + ", version=" + this.version() + ", outputDirectory=" + this.outputDirectory() + ", includeGenerationDate=" + this.includeGenerationDate() + ", customDotExecutable=" + this.customDotExecutable() + ", customFdpExecutable=" + this.customFdpExecutable() + ", pdfFileName=" + this.pdfFileName() + ", debug=" + this.debug() + ")";
    }

    public static class Builder {
        private String domainName;
        private String version;
        private String outputDirectory;
        private boolean includeGenerationDate;
        private boolean customDotExecutable$set;
        private Optional<String> customDotExecutable$value;
        private boolean customFdpExecutable$set;
        private Optional<String> customFdpExecutable$value;
        private String pdfFileName;
        private boolean debug;

        Builder() {
        }

        public Builder domainName(@NonNull String domainName) {
            if (domainName == null) {
                throw new NullPointerException("domainName is marked non-null but is null");
            }
            this.domainName = domainName;
            return this;
        }

        public Builder version(@NonNull String version) {
            if (version == null) {
                throw new NullPointerException("version is marked non-null but is null");
            }
            this.version = version;
            return this;
        }

        public Builder outputDirectory(@NonNull String outputDirectory) {
            if (outputDirectory == null) {
                throw new NullPointerException("outputDirectory is marked non-null but is null");
            }
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder includeGenerationDate(boolean includeGenerationDate) {
            this.includeGenerationDate = includeGenerationDate;
            return this;
        }

        public Builder customDotExecutable(Optional<String> customDotExecutable) {
            this.customDotExecutable$value = customDotExecutable;
            this.customDotExecutable$set = true;
            return this;
        }

        public Builder customFdpExecutable(Optional<String> customFdpExecutable) {
            this.customFdpExecutable$value = customFdpExecutable;
            this.customFdpExecutable$set = true;
            return this;
        }

        public Builder pdfFileName(@NonNull String pdfFileName) {
            if (pdfFileName == null) {
                throw new NullPointerException("pdfFileName is marked non-null but is null");
            }
            this.pdfFileName = pdfFileName;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public PousseCafeDocGenerationConfiguration build() {
            Optional<String> customDotExecutable$value = this.customDotExecutable$value;
            if (!this.customDotExecutable$set) {
                customDotExecutable$value = PousseCafeDocGenerationConfiguration.$default$customDotExecutable();
            }
            Optional<String> customFdpExecutable$value = this.customFdpExecutable$value;
            if (!this.customFdpExecutable$set) {
                customFdpExecutable$value = PousseCafeDocGenerationConfiguration.$default$customFdpExecutable();
            }
            return new PousseCafeDocGenerationConfiguration(this.domainName, this.version, this.outputDirectory, this.includeGenerationDate, customDotExecutable$value, customFdpExecutable$value, this.pdfFileName, this.debug);
        }

        public String toString() {
            return "PousseCafeDocGenerationConfiguration.Builder(domainName=" + this.domainName + ", version=" + this.version + ", outputDirectory=" + this.outputDirectory + ", includeGenerationDate=" + this.includeGenerationDate + ", customDotExecutable$value=" + this.customDotExecutable$value + ", customFdpExecutable$value=" + this.customFdpExecutable$value + ", pdfFileName=" + this.pdfFileName + ", debug=" + this.debug + ")";
        }
    }
}

