/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.xhtmlrenderer.pdf.ITextRenderer;
import org.xhtmlrenderer.util.XRLog;
import poussecafe.doc.PousseCafeDocGenerationConfiguration;
import poussecafe.doc.doclet.Logger;

public class PdfWriter {
    private PousseCafeDocGenerationConfiguration configuration;

    public void writePdf() {
        try {
            if (this.configuration.debug()) {
                System.getProperties().setProperty("xr.util-logging.loggingEnabled", "true");
                XRLog.setLoggingEnabled((boolean)true);
            }
            Logger.debug("Writing PDF...", new Object[0]);
            ITextRenderer pdfRenderer = new ITextRenderer();
            pdfRenderer.setDocument(new File(this.configuration.outputDirectory(), "index.html"));
            pdfRenderer.layout();
            File pdfFile = new File(this.configuration.outputDirectory(), this.configuration.pdfFileName());
            FileOutputStream pdfOutputStream = new FileOutputStream(pdfFile);
            pdfRenderer.createPDF((OutputStream)pdfOutputStream);
            pdfRenderer.finishPDF();
            pdfOutputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while writing PDF", e);
        }
    }

    public PdfWriter(PousseCafeDocGenerationConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }
}

