/*
 * Decompiled with CFR 0.152.
 */
package poussecafe.doc;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import poussecafe.doc.AggregateGraphPath;
import poussecafe.doc.doclet.Logger;
import poussecafe.doc.graph.Node;
import poussecafe.doc.graph.NodeStyle;
import poussecafe.doc.graph.UndirectedEdge;
import poussecafe.doc.graph.UndirectedGraph;
import poussecafe.doc.model.Aggregate;
import poussecafe.doc.model.Domain;
import poussecafe.doc.model.Module;
import poussecafe.doc.model.Relation;
import poussecafe.doc.model.relationdoc.Component;
import poussecafe.doc.model.relationdoc.ComponentType;
import poussecafe.source.analysis.ClassName;

public class AggregateGraphFactory {
    private Set<ClassName> exploredFromClassNames = new HashSet<ClassName>();
    private Aggregate aggregateDoc;
    private UndirectedGraph graph = new UndirectedGraph();
    private Domain domain;
    private Module module;

    public UndirectedGraph buildGraph() {
        String aggregateNodeName = this.addAggregate();
        AggregateGraphPath path = new AggregateGraphPath().with(aggregateNodeName);
        this.addAllRelations(path, this.aggregateDoc.documentation().className().orElseThrow());
        return this.graph;
    }

    private String addAggregate() {
        Logger.debug("Aggregate " + this.aggregateDoc.documentation().id(), new Object[0]);
        String nodeName = this.aggregateDoc.documentation().name();
        Node node = Node.box(nodeName);
        node.setStyle(Optional.of(NodeStyle.BOLD));
        this.graph.getNodesAndEdges().addNode(node);
        return nodeName;
    }

    private void addAllRelations(AggregateGraphPath path, ClassName fromClassName) {
        if (!this.exploredFromClassNames.contains(fromClassName)) {
            this.exploredFromClassNames.add(fromClassName);
            for (Relation relation : this.findWithFromClassName(fromClassName)) {
                Component toComponent = relation.to();
                Logger.debug("Relation " + fromClassName + " -> " + toComponent.className(), new Object[0]);
                if (toComponent.type() != ComponentType.AGGREGATE) {
                    String newNodeName = toComponent.name();
                    AggregateGraphPath newPath = path.with(newNodeName);
                    this.addNonAggregateRelation(path, toComponent, newNodeName);
                    this.addAllRelations(newPath, relation.to().className());
                    continue;
                }
                this.addAggregateRelation(path, toComponent);
            }
        }
    }

    private List<Relation> findWithFromClassName(ClassName fromClassName) {
        return this.domain.relations().stream().filter(item -> item.from().className().equals((Object)fromClassName)).collect(Collectors.toList());
    }

    private void addAggregateRelation(AggregateGraphPath path, Component toComponent) {
        ClassName aggregateClassName = this.aggregateDoc.documentation().className().orElseThrow();
        if (toComponent.className().equals((Object)aggregateClassName)) {
            return;
        }
        Optional<Aggregate> toAggregateDoc = this.module.aggregate(toComponent.name());
        if (toAggregateDoc.isPresent()) {
            String toName = toComponent.name();
            this.addNode(toComponent, toName);
            UndirectedEdge edge = UndirectedEdge.dashedEdge(path.lastName(), toName);
            this.graph.getNodesAndEdges().addEdge(edge);
        }
    }

    private String addNonAggregateRelation(AggregateGraphPath path, Component toComponent, String toName) {
        this.addNode(toComponent, toName);
        UndirectedEdge edge = UndirectedEdge.solidEdge(path.lastName(), toName);
        this.graph.getNodesAndEdges().addEdge(edge);
        return toName;
    }

    private void addNode(Component component, String candidateName) {
        if (this.graph.getNodesAndEdges().getNode(candidateName) == null) {
            Node node = this.node(component, candidateName);
            this.graph.getNodesAndEdges().addNode(node);
        }
    }

    private Node node(Component component, String name) {
        if (component.type() == ComponentType.ENTITY) {
            return Node.box(name);
        }
        if (component.type() == ComponentType.VALUE_OBJECT) {
            return Node.ellipse(name);
        }
        if (component.type() == ComponentType.AGGREGATE) {
            Node node = Node.box(name);
            node.setStyle(Optional.of(NodeStyle.BOLD));
            return node;
        }
        throw new IllegalArgumentException("Unsupported component type " + component.type());
    }

    private AggregateGraphFactory() {
    }

    public static class Builder {
        private AggregateGraphFactory factory = new AggregateGraphFactory();

        public Builder aggregateDoc(Aggregate aggregateDoc) {
            this.factory.aggregateDoc = aggregateDoc;
            return this;
        }

        public Builder domain(Domain domain) {
            this.factory.domain = domain;
            return this;
        }

        public AggregateGraphFactory build() {
            Objects.requireNonNull(this.factory.aggregateDoc);
            Objects.requireNonNull(this.factory.domain);
            this.factory.module = this.factory.domain.module(this.factory.aggregateDoc.documentation().moduleName()).orElseThrow();
            return this.factory;
        }
    }
}

