/*
 * Decompiled with CFR 0.152.
 */
package io.r2dbc.postgresql;

import io.r2dbc.postgresql.ConnectionResources;
import io.r2dbc.postgresql.PostgresqlSqlLexer;
import io.r2dbc.postgresql.PostgresqlStatement;
import io.r2dbc.postgresql.api.PostgresqlResult;
import io.r2dbc.postgresql.util.Assert;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;

final class PostgresqlBatch
implements io.r2dbc.postgresql.api.PostgresqlBatch {
    private final ConnectionResources context;
    private final List<String> statements = new ArrayList<String>();

    PostgresqlBatch(ConnectionResources context) {
        this.context = Assert.requireNonNull(context, "context must not be null");
    }

    @Override
    public PostgresqlBatch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if (PostgresqlSqlLexer.tokenize(sql).getParameterCount() != 0) {
            throw new IllegalArgumentException(String.format("Statement '%s' is not supported.  This is often due to the presence of parameters.", sql));
        }
        this.statements.add(sql);
        return this;
    }

    @Override
    public Flux<PostgresqlResult> execute() {
        return new PostgresqlStatement(this.context, String.join((CharSequence)"; ", this.statements)).execute();
    }

    public String toString() {
        return "PostgresqlBatch{context=" + this.context + ", statements=" + this.statements + '}';
    }
}

