/*
 * Decompiled with CFR 0.152.
 */
package org.plumelib.javadoc;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.DocCommentTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Position;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.checkerframework.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.checker.formatter.qual.UnknownFormat;
import org.checkerframework.checker.index.qual.LessThanUnknown;
import org.checkerframework.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.checker.index.qual.SameLenUnknown;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.interning.qual.Interned;
import org.checkerframework.checker.interning.qual.UnknownInterned;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.mustcall.qual.MustCall;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.checker.regex.qual.UnknownRegex;
import org.checkerframework.checker.signature.qual.SignatureUnknown;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.common.initializedfields.qual.InitializedFields;
import org.checkerframework.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.common.value.qual.UnknownVal;
import org.plumelib.javacparse.JavacParse;
import org.plumelib.javacparse.JavacParseResult;
import org.plumelib.options.Option;
import org.plumelib.options.Options;

public class RequireJavadoc {
    @Option(value="Don't check files or directories whose pathname matches the regex")
    public @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Pattern exclude = null;
    @Option(value="Don't report problems in Java elements whose name matches the regex")
    public @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Pattern dont_require = null;
    @Option(value="Don't report problems in elements with private access")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_private;
    @Option(value="Don't report problems in constructors with zero formal parameters")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_noarg_constructor;
    @Option(value="Don't report problems in trivial getters and setters")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_trivial_properties;
    @Option(value="Don't report problems in type declarations")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_type;
    @Option(value="Don't report problems in fields")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_field;
    @Option(value="Don't report problems in methods and constructors")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean dont_require_method;
    @Option(value="Require package-info.java file to exist")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean require_package_info;
    @Option(value="Report relative rather than absolute filenames")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean relative = false;
    @Option(value="Print diagnostic information")
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean verbose = false;
    private static final  @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Tree.Kind RECORD;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) List<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String> errors = new ArrayList<String>();
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) List<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path> javaFiles = new ArrayList<Path>();
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path workingDirRelative = Paths.get("", new String[0]);
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path workingDirAbsolute = Paths.get("", new String[0]).toAbsolutePath();
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCCompilationUnit currentCompilationUnit;
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) RequireJavadoc. @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) RequireJavadocVisitor visitor;
    static final /* synthetic */ boolean $assertionsDisabled;

    private RequireJavadoc() {
    }

    public static void main(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] args) {
        RequireJavadoc rj = new RequireJavadoc();
        Options options = new Options("java org.plumelib.javadoc.RequireJavadoc [options] [directory-or-file ...]", new Object[]{rj});
        String[] remainingArgs = options.parse(true, args);
        rj.setJavaFiles(remainingArgs);
        ArrayList<CallSite> exceptionsThrown = new ArrayList<CallSite>();
        for (Path path : rj.javaFiles) {
            if (rj.verbose) {
                System.out.println("Checking " + String.valueOf(path));
            }
            try {
                JCTree.JCCompilationUnit cu;
                JavacParseResult jpr = JavacParse.parseJavaFile((String)path.toString());
                rj.currentCompilationUnit = cu = jpr.getCompilationUnit();
                RequireJavadoc requireJavadoc = rj;
                Objects.requireNonNull(requireJavadoc);
                rj.visitor = requireJavadoc.new RequireJavadocVisitor(path);
                rj.visitor.visitTopLevel(cu);
            }
            catch (IOException e) {
                exceptionsThrown.add((CallSite)((Object)("Problem while reading " + String.valueOf(path) + ": " + e.getMessage())));
            }
        }
        for (String string : rj.errors) {
            System.out.println(string);
        }
        if (!exceptionsThrown.isEmpty()) {
            for (String string : exceptionsThrown) {
                System.out.println(string);
            }
            System.exit(2);
        }
        System.exit(rj.errors.isEmpty() ? 0 : 1);
    }

    private void setJavaFiles(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] args) {
        if (args.length == 0) {
            args = new String[]{this.workingDirAbsolute.toString()};
        }
        JavaFilesVisitor walker = new JavaFilesVisitor();
        for (String arg : args) {
            if (this.shouldExclude(arg)) continue;
            Path p = Paths.get(arg, new String[0]);
            File f = p.toFile();
            if (!f.exists()) {
                System.out.println("File not found: " + String.valueOf(f));
                System.exit(2);
            }
            if (f.isDirectory()) {
                try {
                    Files.walkFileTree(p, walker);
                }
                catch (IOException e) {
                    System.out.println("Problem while reading " + String.valueOf(f) + ": " + e.getMessage());
                    System.exit(2);
                }
                continue;
            }
            this.javaFiles.add(Paths.get(arg, new String[0]));
        }
        this.javaFiles.sort(Comparator.comparing(Object::toString));
        LinkedHashSet<Path> missingPackageInfoFiles = new LinkedHashSet<Path>();
        if (this.require_package_info) {
            for (Path javaFile : this.javaFiles) {
                @NonNull Path javaFileParent = javaFile.getParent();
                Path packageInfo = javaFileParent.resolve(new File("package-info.java").toPath());
                if (this.javaFiles.contains(packageInfo)) continue;
                missingPackageInfoFiles.add(packageInfo);
            }
            for (Path packageInfo : missingPackageInfoFiles) {
                this.errors.add("missing package documentation: no file " + String.valueOf(packageInfo));
            }
        }
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean shouldNotRequire(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String name) {
        if (this.dont_require == null) {
            return false;
        }
        boolean result = this.dont_require.matcher(name).find();
        if (this.verbose) {
            System.out.printf("shouldNotRequire(%s) => %s%n", name, result);
        }
        return result;
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean shouldExclude(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String fileName) {
        if (this.exclude == null) {
            return false;
        }
        boolean result = this.exclude.matcher(fileName).find();
        if (this.verbose) {
            System.out.printf("shouldExclude(%s) => %s%n", fileName, result);
        }
        return result;
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean shouldExclude(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path path) {
        return this.shouldExclude(path.toString());
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isTrivialGetterOrSetter(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md) {
        PropertyKind kind = PropertyKind.fromMethodDeclaration(md);
        if (kind != PropertyKind.GETTER_NO_PREFIX && this.isTrivialGetterOrSetter(md, kind)) {
            return true;
        }
        return this.isTrivialGetterOrSetter(md, PropertyKind.GETTER_NO_PREFIX);
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isTrivialGetterOrSetter(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) PropertyKind propertyKind) {
        String propertyName = this.propertyName(md, propertyKind);
        return propertyName != null && this.hasCorrectSignature(md, propertyKind, propertyName) && this.hasCorrectBody(md, propertyKind, propertyName);
    }

    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String propertyName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) PropertyKind propertyKind) {
        String methodName = md.getName().toString();
        if (!$assertionsDisabled && !methodName.startsWith(propertyKind.prefix)) {
            throw new AssertionError();
        }
        String upperCamelCaseProperty = methodName.substring(propertyKind.prefix.length());
        if (upperCamelCaseProperty.length() == 0) {
            return null;
        }
        if (propertyKind == PropertyKind.GETTER_NO_PREFIX) {
            return upperCamelCaseProperty;
        }
        if (!Character.isUpperCase(upperCamelCaseProperty.charAt(0))) {
            return null;
        }
        return Character.toLowerCase(upperCamelCaseProperty.charAt(0)) + upperCamelCaseProperty.substring(1);
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean hasCorrectSignature(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) PropertyKind propertyKind, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String propertyName) {
        JCTree.JCVariableDecl parameter;
        List parameters = md.getParameters();
        if (parameters.size() != propertyKind.requiredParams) {
            return false;
        }
        if (parameters.size() == 1 && !(parameter = (JCTree.JCVariableDecl)parameters.get(0)).getName().toString().equals(propertyName)) {
            return false;
        }
        JCTree returnType = md.getReturnType();
        switch (propertyKind.returnType) {
            case VOID: {
                return this.isTypeWithKind(returnType, TypeKind.VOID);
            }
            case BOOLEAN: {
                return this.isTypeWithKind(returnType, TypeKind.BOOLEAN);
            }
            case NON_VOID: {
                return !this.isTypeWithKind(returnType, TypeKind.VOID);
            }
        }
        throw new Error("Unexpected enum value " + String.valueOf((Object)propertyKind.returnType));
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isTypeWithKind(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree tree, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) TypeKind typeKind) {
        return tree instanceof JCTree.JCPrimitiveTypeTree && typeKind == ((JCTree.JCPrimitiveTypeTree)tree).getPrimitiveTypeKind();
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean hasCorrectBody(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) PropertyKind propertyKind, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String propertyName) {
        JCTree.JCStatement statement = this.getOnlyStatement(md);
        if (statement == null) {
            return false;
        }
        if (propertyKind.isGetter()) {
            String returnName;
            if (!(statement instanceof JCTree.JCReturn)) {
                return false;
            }
            JCTree.JCExpression returnExpr = ((JCTree.JCReturn)statement).getExpression();
            if (returnExpr == null) {
                return false;
            }
            if (propertyKind == PropertyKind.GETTER_NOT) {
                if (!(returnExpr instanceof JCTree.JCUnary)) {
                    return false;
                }
                JCTree.JCUnary unary = (JCTree.JCUnary)returnExpr;
                if (unary.getTag() != JCTree.Tag.NOT) {
                    return false;
                }
                returnExpr = unary.getExpression();
            }
            return (returnName = this.asFieldName(returnExpr)) != null && returnName.equals(propertyName);
        }
        if (propertyKind == PropertyKind.SETTER) {
            if (!(statement instanceof JCTree.JCExpressionStatement)) {
                return false;
            }
            JCTree.JCExpression expr = ((JCTree.JCExpressionStatement)statement).getExpression();
            if (!(expr instanceof JCTree.JCAssign)) {
                return false;
            }
            JCTree.JCAssign assignExpr = (JCTree.JCAssign)expr;
            JCTree.JCExpression assignLhs = assignExpr.getVariable();
            String lhsName = this.asFieldName(assignLhs);
            if (lhsName == null || !lhsName.equals(propertyName)) {
                return false;
            }
            JCTree.JCExpression assignRhs = assignExpr.getExpression();
            return assignRhs instanceof JCTree.JCIdent && ((JCTree.JCIdent)assignRhs).getName().toString().equals(propertyName);
        }
        throw new Error("unexpected PropertyKind " + String.valueOf((Object)propertyKind));
    }

    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String asFieldName(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCExpression expr) {
        if (expr instanceof JCTree.JCIdent) {
            return ((JCTree.JCIdent)expr).getName().toString();
        }
        if (expr instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess fa = (JCTree.JCFieldAccess)expr;
            JCTree.JCExpression receiver = fa.getExpression();
            if (!(receiver == null || receiver instanceof JCTree.JCIdent && ((JCTree.JCIdent)receiver).getName().toString().equals("this"))) {
                return null;
            }
            return fa.getIdentifier().toString();
        }
        return null;
    }

    private @Nullable @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCStatement getOnlyStatement(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md) {
        JCTree.JCBlock body = md.getBody();
        if (body == null) {
            return null;
        }
        List statements = body.getStatements();
        if (statements.size() != 1) {
            return null;
        }
        return (JCTree.JCStatement)statements.get(0);
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean hasJavadocComment(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree t) {
        DocCommentTable docComments = this.currentCompilationUnit.docComments;
        return docComments != null && docComments.hasComment(t);
    }

    static {
        boolean bl = $assertionsDisabled = !RequireJavadoc.class.desiredAssertionStatus();
        if (Runtime.version().feature() >= 16) {
            try {
                Field recordField = Tree.Kind.class.getDeclaredField("RECORD");
                Tree.Kind recordFieldValue = (Tree.Kind)((Object)recordField.get(null));
                if (recordFieldValue == null) {
                    throw new Error("Field RECORD is nill Tree.Kind");
                }
                RECORD = recordFieldValue;
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new Error("Cannot find field RECORD in Tree.Kind", e);
            }
        } else {
            RECORD = Tree.Kind.OTHER;
        }
    }

    private class RequireJavadocVisitor
    extends JCTree.Visitor {
        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path filename;
        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCCompilationUnit cu;
        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Deque<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String> classNames = new ArrayDeque<String>();

        public RequireJavadocVisitor(Path filename) {
            this.filename = filename;
        }

        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String errorString(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree tree, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String simpleName) {
            int pos = tree.getStartPosition();
            if ((long)pos == -1L) {
                return "missing documentation for " + simpleName;
            }
            Path path = RequireJavadoc.this.relative ? (this.filename.isAbsolute() ? RequireJavadoc.this.workingDirAbsolute : RequireJavadoc.this.workingDirRelative).relativize(this.filename) : this.filename;
            Position.LineMap lineMap = this.cu.getLineMap();
            return String.format("%s:%d:%d: missing documentation for %s", path, lineMap.getLineNumber((long)pos), lineMap.getColumnNumber((long)pos), simpleName);
        }

        @Override
        public void visitTree(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree that) {
        }

        @Override
        public void visitTopLevel(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCCompilationUnit cu) {
            this.cu = cu;
            JCTree.JCPackageDecl pd = cu.getPackage();
            String packageName = null;
            if (pd != null && RequireJavadoc.this.shouldNotRequire(packageName = pd.getPackageName().toString())) {
                return;
            }
            String fileName = cu.getSourceFile().getName();
            if ((fileName.endsWith("package-info.java") || fileName.endsWith("module-info.java")) && !RequireJavadoc.this.hasJavadocComment(pd)) {
                if (packageName == null) {
                    throw new Error("null package for " + fileName);
                }
                RequireJavadoc.this.errors.add(this.errorString(pd, packageName));
            }
            if (RequireJavadoc.this.verbose) {
                System.out.printf("Visiting compilation unit%n", new Object[0]);
            }
            for (JCTree def : cu.defs) {
                def.accept(this);
            }
        }

        @Override
        public void visitClassDef(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCClassDecl cd) {
            if (RequireJavadoc.this.dont_require_private && cd.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                return;
            }
            String name = cd.getSimpleName().toString();
            if (RequireJavadoc.this.shouldNotRequire(name)) {
                return;
            }
            if (RequireJavadoc.this.verbose) {
                System.out.printf("Visiting type %s%n", name);
            }
            this.classNames.addFirst(name);
            if (!RequireJavadoc.this.dont_require_type && !RequireJavadoc.this.hasJavadocComment(cd)) {
                RequireJavadoc.this.errors.add(this.errorString(cd, name));
            }
            if (cd.getKind() != RECORD) {
                for (JCTree def : cd.defs) {
                    def.accept(this);
                }
            }
            this.classNames.removeFirst();
        }

        @Override
        public void visitMethodDef(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md) {
            if (RequireJavadoc.this.dont_require_private && md.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                return;
            }
            if (RequireJavadoc.this.dont_require_trivial_properties && RequireJavadoc.this.isTrivialGetterOrSetter(md)) {
                if (RequireJavadoc.this.verbose) {
                    System.out.printf("skipping trivial property method %s%n", md.getName().toString());
                }
                return;
            }
            @NonNull String name = md.getName().toString();
            if (name.equals("<init>")) {
                String tmpName;
                name = tmpName = this.classNames.peekFirst();
            }
            if (RequireJavadoc.this.shouldNotRequire(name)) {
                return;
            }
            if (RequireJavadoc.this.verbose) {
                System.out.printf("Visiting method %s%n", md.getName());
            }
            if (!(RequireJavadoc.this.dont_require_method || this.isOverride(md) || RequireJavadoc.this.hasJavadocComment(md))) {
                RequireJavadoc.this.errors.add(this.errorString(md, name));
            }
        }

        @Override
        public void visitVarDef(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCVariableDecl fd) {
            if (RequireJavadoc.this.dont_require_private && fd.getModifiers().getFlags().contains((Object)Modifier.PRIVATE)) {
                return;
            }
            String name = fd.getName().toString();
            if (RequireJavadoc.this.verbose) {
                System.out.printf("Visiting field %s%n", name);
            }
            if (name.equals("serialVersionUID")) {
                return;
            }
            if (RequireJavadoc.this.shouldNotRequire(name)) {
                return;
            }
            if (!RequireJavadoc.this.dont_require_field && !RequireJavadoc.this.hasJavadocComment(fd)) {
                RequireJavadoc.this.errors.add(this.errorString(fd, name));
            }
        }

        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isOverride(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md) {
            for (JCTree.JCAnnotation anno : md.getModifiers().getAnnotations()) {
                String annoName = anno.getAnnotationType().toString();
                if (!annoName.equals("Override") && !annoName.equals("java.lang.Override")) continue;
                return true;
            }
            return false;
        }
    }

    private static enum PropertyKind {
        GETTER("get", 0, ReturnType.NON_VOID),
        GETTER_NO_PREFIX("", 0, ReturnType.NON_VOID),
        GETTER_HAS("has", 0, ReturnType.BOOLEAN),
        GETTER_IS("is", 0, ReturnType.BOOLEAN),
        GETTER_NOT("not", 0, ReturnType.BOOLEAN),
        SETTER("set", 1, ReturnType.VOID),
        NOT_PROPERTY("", -1, ReturnType.VOID);

        final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String prefix;
        final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int requiredParams;
        final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) ReturnType returnType;

        private PropertyKind(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String prefix, int requiredParams, ReturnType returnType) {
            this.prefix = prefix;
            this.requiredParams = requiredParams;
            this.returnType = returnType;
        }

        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isGetter() {
            return this != SETTER;
        }

        static @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) PropertyKind fromMethodDeclaration(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) JCTree.JCMethodDecl md) {
            String methodName = md.getName().toString();
            if (methodName.startsWith("get")) {
                return GETTER;
            }
            if (methodName.startsWith("has")) {
                return GETTER_HAS;
            }
            if (methodName.startsWith("is")) {
                return GETTER_IS;
            }
            if (methodName.startsWith("not")) {
                return GETTER_NOT;
            }
            if (methodName.startsWith("set")) {
                return SETTER;
            }
            return GETTER_NO_PREFIX;
        }
    }

    private static enum ReturnType {
        VOID,
        BOOLEAN,
        NON_VOID;

    }

    private class JavaFilesVisitor
    extends SimpleFileVisitor<Path> {
        @Override
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) FileVisitResult visitFile(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path file, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BasicFileAttributes attr) {
            if (attr.isRegularFile() && file.toString().endsWith(".java") && !RequireJavadoc.this.shouldExclude(file)) {
                RequireJavadoc.this.javaFiles.add(file);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) FileVisitResult preVisitDirectory(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path dir, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BasicFileAttributes attr) {
            if (RequireJavadoc.this.shouldExclude(dir)) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) FileVisitResult postVisitDirectory(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path dir, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) IOException exc) {
            if (exc != null) {
                System.out.println("Problem visiting " + String.valueOf(dir) + ": " + exc.getMessage());
                System.exit(2);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) FileVisitResult visitFileFailed(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Path file, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) IOException exc) {
            if (exc != null) {
                System.out.println("Problem visiting " + String.valueOf(file) + ": " + exc.getMessage());
                System.exit(2);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

