/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.oauth.oauth.signpost.signature;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import play.shaded.oauth.oauth.signpost.OAuth;
import play.shaded.oauth.oauth.signpost.exception.OAuthMessageSignerException;
import play.shaded.oauth.oauth.signpost.http.HttpParameters;
import play.shaded.oauth.oauth.signpost.http.HttpRequest;
import play.shaded.oauth.oauth.signpost.signature.OAuthMessageSigner;
import play.shaded.oauth.oauth.signpost.signature.SignatureBaseString;

public class HmacSha256MessageSigner
extends OAuthMessageSigner {
    private static final String MAC_NAME = "HmacSHA256";

    @Override
    public String getSignatureMethod() {
        return "HMAC-SHA256";
    }

    @Override
    public String sign(HttpRequest request, HttpParameters requestParams) throws OAuthMessageSignerException {
        try {
            String keyString = OAuth.percentEncode(this.getConsumerSecret()) + '&' + OAuth.percentEncode(this.getTokenSecret());
            byte[] keyBytes = keyString.getBytes("UTF-8");
            SecretKeySpec key = new SecretKeySpec(keyBytes, MAC_NAME);
            Mac mac = Mac.getInstance(MAC_NAME);
            mac.init(key);
            String sbs = new SignatureBaseString(request, requestParams).generate();
            OAuth.debugOut("SBS", sbs);
            byte[] text = sbs.getBytes("UTF-8");
            return this.base64Encode(mac.doFinal(text)).trim();
        }
        catch (GeneralSecurityException e) {
            throw new OAuthMessageSignerException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuthMessageSignerException(e);
        }
    }
}

