/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.scaladsl.FileIO$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import play.api.http.ContentTypes$;
import play.api.http.HeaderNames$;
import play.api.http.HttpEntity$Streamed$;
import play.api.http.HttpEntity$Strict$;
import play.api.http.Status$;
import play.api.mvc.ByteRange;
import play.api.mvc.NoHeaderRangeSet;
import play.api.mvc.Range;
import play.api.mvc.RangeResult$;
import play.api.mvc.RangeSet;
import play.api.mvc.RangeSet$;
import play.api.mvc.ResponseHeader$;
import play.api.mvc.Result;
import play.api.mvc.Result$;
import play.api.mvc.Results$;
import play.api.mvc.SatisfiableRangeSet;
import play.api.mvc.UnsatisfiableRangeSet;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class RangeResult$
implements Serializable {
    public static final RangeResult$ MODULE$ = new RangeResult$();

    private RangeResult$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RangeResult$.class);
    }

    public Result ofStream(InputStream stream, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofSource((Option<Object>)None$.MODULE$, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> stream, StreamConverters$.MODULE$.fromInputStream$default$2()), rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofStream(long entityLength, InputStream stream, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofSource(entityLength, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable)() -> stream, StreamConverters$.MODULE$.fromInputStream$default$2()), rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofPath(Path path, Option<String> rangeHeader, Option<String> contentType) {
        return this.ofPath(path, rangeHeader, path.getFileName().toString(), contentType);
    }

    public Result ofPath(Path path, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        Function1 & Serializable source = (Function1 & Serializable)start -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)start)), (Object)FileIO$.MODULE$.fromPath(path, 8192, BoxesRunTime.unboxToLong((Object)start)));
        return this.ofSource((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)Files.size(path))), source, rangeHeader, (Option<String>)Option$.MODULE$.apply((Object)fileName), contentType);
    }

    public Result ofFile(File file, Option<String> rangeHeader, Option<String> contentType) {
        return this.ofFile(file, rangeHeader, file.getName(), contentType);
    }

    public Result ofFile(File file, Option<String> rangeHeader, String fileName, Option<String> contentType) {
        return this.ofPath(file.toPath(), rangeHeader, fileName, contentType);
    }

    public Result ofSource(long entityLength, Source<ByteString, ?> source, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        return this.ofSource((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)entityLength)), source, rangeHeader, fileName, contentType);
    }

    public Result ofSource(Option<Object> entityLength, Source<ByteString, ?> source, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        return this.ofSource(entityLength, (Function1 & Serializable)_$7 -> Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)0L), (Object)source), rangeHeader, fileName, contentType);
    }

    @ApiMayChange
    public Result ofSource(Option<Object> entityLength, Function1<Object, Tuple2<Object, Source<ByteString, ?>>> getSource, Option<String> rangeHeader, Option<String> fileName, Option<String> contentType) {
        Builder buf = Predef$.MODULE$.Map().newBuilder();
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ACCEPT_RANGES());
        buf.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"bytes"));
        fileName.foreach((Function1 & Serializable)f -> (Builder)buf.$plus$plus$eq(Results$.MODULE$.contentDispositionHeader(false, fileName)));
        Map commonHeaders = (Map)buf.result();
        RangeSet rangeSet = RangeSet$.MODULE$.apply(entityLength, rangeHeader);
        if (rangeSet instanceof SatisfiableRangeSet) {
            SatisfiableRangeSet rangeSet2 = (SatisfiableRangeSet)rangeSet;
            Range firstRange = rangeSet2.first();
            ByteRange byteRange = firstRange.byteRange();
            Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)byteRange.start()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long offset = BoxesRunTime.unboxToLong((Object)tuple2._1());
            Source source = (Source)tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset), (Object)source);
            long offset2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
            Source source2 = (Source)tuple22._2();
            Predef$.MODULE$.require(offset2 <= byteRange.start(), () -> RangeResult$.ofSource$$anonfun$2(byteRange, offset2));
            long start = byteRange.start() - offset2;
            Source entitySource = source2.via(this.sliceBytesTransformer(start, firstRange.length()));
            Object[] objectArray = new Tuple2[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_RANGE());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)rangeSet2.toString());
            return Result$.MODULE$.apply(ResponseHeader$.MODULE$.apply(Status$.MODULE$.PARTIAL_CONTENT(), (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)commonHeaders)), ResponseHeader$.MODULE$.apply$default$3()), HttpEntity$Streamed$.MODULE$.apply(entitySource, firstRange.length(), (Option<String>)contentType.orElse(RangeResult$::ofSource$$anonfun$3)), Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
        }
        if (rangeSet instanceof UnsatisfiableRangeSet) {
            UnsatisfiableRangeSet rangeSet3 = (UnsatisfiableRangeSet)rangeSet;
            Object[] objectArray = new Tuple2[1];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONTENT_RANGE());
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)rangeSet3.toString());
            return Result$.MODULE$.apply(ResponseHeader$.MODULE$.apply(Status$.MODULE$.REQUESTED_RANGE_NOT_SATISFIABLE(), (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus$plus((IterableOnce)commonHeaders)), ResponseHeader$.MODULE$.apply$default$3()), HttpEntity$Strict$.MODULE$.apply(ByteString$.MODULE$.empty(), contentType), Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
        }
        if (rangeSet instanceof NoHeaderRangeSet) {
            Option<Object> option = entityLength;
            if (option instanceof Some) {
                long entityLen = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (entityLen > 0L) {
                    Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)0L));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Source source = (Source)tuple2._2();
                    Source source3 = source;
                    return Result$.MODULE$.apply(ResponseHeader$.MODULE$.apply(Status$.MODULE$.OK(), (Map<String, String>)commonHeaders, ResponseHeader$.MODULE$.apply$default$3()), HttpEntity$Streamed$.MODULE$.apply(source3, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)entityLen)), (Option<String>)contentType.orElse(RangeResult$::ofSource$$anonfun$4)), Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
                }
                return Results$.MODULE$.Ok().sendEntity(HttpEntity$Strict$.MODULE$.apply(ByteString$.MODULE$.empty(), contentType));
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2 tuple2 = (Tuple2)getSource.apply((Object)BoxesRunTime.boxToLong((long)0L));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Source source = (Source)tuple2._2();
                Source source4 = source;
                return Result$.MODULE$.apply(ResponseHeader$.MODULE$.apply(Status$.MODULE$.OK(), (Map<String, String>)commonHeaders, ResponseHeader$.MODULE$.apply$default$3()), HttpEntity$Streamed$.MODULE$.apply(source4, (Option<Object>)None$.MODULE$, (Option<String>)contentType.orElse(RangeResult$::ofSource$$anonfun$5)), Result$.MODULE$.$lessinit$greater$default$3(), Result$.MODULE$.$lessinit$greater$default$4(), Result$.MODULE$.$lessinit$greater$default$5(), Result$.MODULE$.$lessinit$greater$default$6());
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)rangeSet);
    }

    private Flow<ByteString, ByteString, NotUsed> sliceBytesTransformer(long start, Option<Object> length) {
        GraphStage<FlowShape<ByteString, ByteString>> transformer = new GraphStage<FlowShape<ByteString, ByteString>>(start, length){
            private final long start$1;
            private final Option length$1;
            private final Inlet in;
            private final Outlet out;
            private final FlowShape shape;
            {
                this.start$1 = start$3;
                this.length$1 = length$3;
                this.in = Inlet$.MODULE$.apply("Slicer.in");
                this.out = Outlet$.MODULE$.apply("Slicer.out");
                this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
            }

            public Inlet in() {
                return this.in;
            }

            public Outlet out() {
                return this.out;
            }

            public FlowShape shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new InHandler(this.start$1, this.length$1, this){
                    private long toSkip;
                    private long remaining;
                    private final /* synthetic */ anon.1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super((Shape)$outer.shape());
                        this.toSkip = start$2;
                        this.remaining = BoxesRunTime.unboxToLong((Object)length$2.getOrElse(RangeResult$::play$api$mvc$RangeResult$$anon$2$$_$$lessinit$greater$$anonfun$1));
                        this.setHandlers($outer.in(), $outer.out(), this);
                    }

                    public long toSkip() {
                        return this.toSkip;
                    }

                    public void toSkip_$eq(long x$1) {
                        this.toSkip = x$1;
                    }

                    public long remaining() {
                        return this.remaining;
                    }

                    public void remaining_$eq(long x$1) {
                        this.remaining = x$1;
                    }

                    public void onPush() {
                        ByteString element = (ByteString)this.grab(this.$outer.in());
                        if (this.toSkip() >= (long)element.length()) {
                            this.pull(this.$outer.in());
                        } else {
                            ByteString data = element.drop((int)this.toSkip()).take((int)package$.MODULE$.min(this.remaining(), Integer.MAX_VALUE));
                            this.remaining_$eq(this.remaining() - (long)data.size());
                            this.push(this.$outer.out(), data);
                            if (this.remaining() <= 0L) {
                                this.completeStage();
                            }
                        }
                        this.toSkip_$eq(this.toSkip() - (long)element.length());
                    }

                    public void onPull() {
                        this.pull(this.$outer.in());
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{play$api$mvc$RangeResult$$anon$2$$_$$lessinit$greater$$anonfun$1()}, serializedLambda);
                    }
                };
            }
        };
        return Flow$.MODULE$.apply().via((Graph)transformer).named("sliceBytes");
    }

    private static final Object ofSource$$anonfun$2(ByteRange byteRange$1, long offset$1) {
        return "Requested range starts at " + byteRange$1.start() + " but the getSource function returned an offset of " + offset$1 + ". It should not seek past the start range.";
    }

    private static final Option ofSource$$anonfun$3() {
        return Some$.MODULE$.apply((Object)ContentTypes$.MODULE$.BINARY());
    }

    private static final Option ofSource$$anonfun$4() {
        return Some$.MODULE$.apply((Object)ContentTypes$.MODULE$.BINARY());
    }

    private static final Option ofSource$$anonfun$5() {
        return Some$.MODULE$.apply((Object)ContentTypes$.MODULE$.BINARY());
    }

    public static final long play$api$mvc$RangeResult$$anon$2$$_$$lessinit$greater$$anonfun$1() {
        return Integer.MAX_VALUE;
    }
}

