/*
 * Decompiled with CFR 0.152.
 */
package play.api.mvc;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Locale;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Sink$;
import org.apache.pekko.stream.scaladsl.StreamConverters$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.xml.sax.InputSource;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.Play$;
import play.api.data.DefaultFormBinding;
import play.api.data.Form;
import play.api.data.Form$;
import play.api.data.FormBinding;
import play.api.http.HttpErrorHandler;
import play.api.http.MediaType;
import play.api.http.ParserConfiguration;
import play.api.http.Status$;
import play.api.libs.Files;
import play.api.libs.Files$TemporaryFile$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.AnyContent;
import play.api.mvc.AnyContentAsEmpty$;
import play.api.mvc.AnyContentAsFormUrlEncoded$;
import play.api.mvc.AnyContentAsJson$;
import play.api.mvc.AnyContentAsMultipartFormData$;
import play.api.mvc.AnyContentAsRaw$;
import play.api.mvc.AnyContentAsText$;
import play.api.mvc.AnyContentAsXml$;
import play.api.mvc.BodyParser;
import play.api.mvc.BodyParser$;
import play.api.mvc.BodyParserUtils;
import play.api.mvc.BodyParserUtils$;
import play.api.mvc.BodyParsers;
import play.api.mvc.MaxSizeExceeded;
import play.api.mvc.MaxSizeExceeded$;
import play.api.mvc.MaxSizeNotExceeded$;
import play.api.mvc.MaxSizeStatus;
import play.api.mvc.MultipartFormData;
import play.api.mvc.PlayBodyParsers$;
import play.api.mvc.RawBuffer;
import play.api.mvc.RawBuffer$;
import play.api.mvc.Request$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.core.Execution$;
import play.core.Execution$Implicits$;
import play.core.parsers.FormUrlEncodedParser$;
import play.core.parsers.Multipart;
import play.core.parsers.Multipart$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;
import scala.xml.NodeSeq;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public interface PlayBodyParsers
extends BodyParserUtils {
    public static PlayBodyParsers apply(Files.TemporaryFileCreator temporaryFileCreator, HttpErrorHandler httpErrorHandler, ParserConfiguration parserConfiguration, Materializer materializer) {
        return PlayBodyParsers$.MODULE$.apply(temporaryFileCreator, httpErrorHandler, parserConfiguration, materializer);
    }

    public static Files.TemporaryFileCreator apply$default$1() {
        return PlayBodyParsers$.MODULE$.apply$default$1();
    }

    public static HttpErrorHandler apply$default$2() {
        return PlayBodyParsers$.MODULE$.apply$default$2();
    }

    public static ParserConfiguration apply$default$3() {
        return PlayBodyParsers$.MODULE$.apply$default$3();
    }

    public static void $init$(PlayBodyParsers $this) {
        $this.play$api$mvc$PlayBodyParsers$_setter_$play$api$mvc$PlayBodyParsers$$logger_$eq(Logger$.MODULE$.apply(PlayBodyParsers.class));
        $this.play$api$mvc$PlayBodyParsers$_setter_$UNLIMITED_$eq(Long.MAX_VALUE);
        $this.play$api$mvc$PlayBodyParsers$_setter_$ApplicationXmlMatcher_$eq(StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("application/.*\\+xml.*")));
    }

    public Logger play$api$mvc$PlayBodyParsers$$logger();

    public void play$api$mvc$PlayBodyParsers$_setter_$play$api$mvc$PlayBodyParsers$$logger_$eq(Logger var1);

    public Materializer materializer();

    public ParserConfiguration config();

    public HttpErrorHandler errorHandler();

    public Files.TemporaryFileCreator temporaryFileCreator();

    public long UNLIMITED();

    public void play$api$mvc$PlayBodyParsers$_setter_$UNLIMITED_$eq(long var1);

    public Regex ApplicationXmlMatcher();

    public void play$api$mvc$PlayBodyParsers$_setter_$ApplicationXmlMatcher_$eq(Regex var1);

    public static long DefaultMaxTextLength$(PlayBodyParsers $this) {
        return $this.DefaultMaxTextLength();
    }

    default public long DefaultMaxTextLength() {
        return this.config().maxMemoryBuffer();
    }

    public static long DefaultMaxDiskLength$(PlayBodyParsers $this) {
        return $this.DefaultMaxDiskLength();
    }

    default public long DefaultMaxDiskLength() {
        return this.config().maxDiskBuffer();
    }

    public static boolean DefaultAllowEmptyFileUploads$(PlayBodyParsers $this) {
        return $this.DefaultAllowEmptyFileUploads();
    }

    default public boolean DefaultAllowEmptyFileUploads() {
        return this.config().allowEmptyFiles();
    }

    public static FormBinding formBinding$(PlayBodyParsers $this, long maxChars, int maxDepth) {
        return $this.formBinding(maxChars, maxDepth);
    }

    default public FormBinding formBinding(long maxChars, int maxDepth) {
        return new DefaultFormBinding(maxChars, maxDepth);
    }

    public static long formBinding$default$1$(PlayBodyParsers $this) {
        return $this.formBinding$default$1();
    }

    default public long formBinding$default$1() {
        return this.DefaultMaxTextLength();
    }

    public static int formBinding$default$2$(PlayBodyParsers $this) {
        return $this.formBinding$default$2();
    }

    default public int formBinding$default$2() {
        return Form$.MODULE$.FromJsonMaxDepth();
    }

    public static BodyParser tolerantText$(PlayBodyParsers $this, long maxLength) {
        return $this.tolerantText(maxLength);
    }

    default public BodyParser<String> tolerantText(long maxLength) {
        return this.tolerantBodyParser("text", maxLength, "Error decoding text body", (Function2 & Serializable)(request, bytes) -> {
            ByteBuffer byteBuffer = bytes.toByteBuffer();
            Charset charset = (Charset)request.charset().fold(PlayBodyParsers::$anonfun$2, (Function1 & Serializable)x$0 -> Charset.forName(x$0));
            return (String)this.play$api$mvc$PlayBodyParsers$$_$decode$1(byteBuffer, (RequestHeader)request, charset).recoverWith((PartialFunction)new Serializable(byteBuffer, (RequestHeader)request, this){
                private final ByteBuffer byteBuffer$2;
                private final RequestHeader request$12;
                private final /* synthetic */ PlayBodyParsers $outer;
                {
                    this.byteBuffer$2 = byteBuffer$4;
                    this.request$12 = request$15;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return throwable instanceof CharacterCodingException;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof CharacterCodingException) {
                        return this.$outer.play$api$mvc$PlayBodyParsers$$_$decode$1(this.byteBuffer$2, this.request$12, StandardCharsets.UTF_8);
                    }
                    return function1.apply((Object)x);
                }
            }).recoverWith((PartialFunction)new Serializable(byteBuffer, (RequestHeader)request, this){
                private final ByteBuffer byteBuffer$3;
                private final RequestHeader request$13;
                private final /* synthetic */ PlayBodyParsers $outer;
                {
                    this.byteBuffer$3 = byteBuffer$5;
                    this.request$13 = request$16;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return throwable instanceof CharacterCodingException;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof CharacterCodingException) {
                        return this.$outer.play$api$mvc$PlayBodyParsers$$_$decode$1(this.byteBuffer$3, this.request$13, StandardCharsets.ISO_8859_1);
                    }
                    return function1.apply((Object)x);
                }
            }).getOrElse(() -> PlayBodyParsers.tolerantText$$anonfun$1$$anonfun$1(bytes, charset));
        });
    }

    public static BodyParser tolerantText$(PlayBodyParsers $this) {
        return $this.tolerantText();
    }

    default public BodyParser<String> tolerantText() {
        return this.tolerantText(this.DefaultMaxTextLength());
    }

    public static BodyParser text$(PlayBodyParsers $this, long maxLength) {
        return $this.text(maxLength);
    }

    default public BodyParser<String> text(long maxLength) {
        return BodyParser$.MODULE$.apply("text", (Function1 & Serializable)request2 -> {
            if (request2.contentType().exists((Function1 & Serializable)_$9 -> _$9.equalsIgnoreCase("text/plain"))) {
                BodyParser bodyParser = this.tolerantBodyParser("text", maxLength, "Error decoding text body", (Function2 & Serializable)(request, bytes) -> {
                    String string;
                    Charset charset = (Charset)request.charset().fold(PlayBodyParsers::$anonfun$5, (Function1 & Serializable)x$0 -> Charset.forName(x$0));
                    CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
                    try {
                        string = decoder.decode(bytes.toByteBuffer()).toString();
                    }
                    catch (CharacterCodingException e) {
                        this.play$api$mvc$PlayBodyParsers$$logger().warn(() -> PlayBodyParsers.$anonfun$4$$anonfun$1(request, charset), MarkerContext$.MODULE$.NoMarker());
                        string = bytes.decodeString(charset);
                    }
                    return string;
                });
                return (Accumulator)bodyParser.apply(request2);
            }
            Function1<RequestHeader, Future<Result>> badResult = this.createBadResult("Expecting text/plain body", Status$.MODULE$.UNSUPPORTED_MEDIA_TYPE());
            return Accumulator$.MODULE$.done(((Future)badResult.apply(request2)).map((Function1 & Serializable)value -> package$.MODULE$.Left().apply(value), (ExecutionContext)Execution$.MODULE$.trampoline()));
        });
    }

    public static BodyParser text$(PlayBodyParsers $this) {
        return $this.text();
    }

    default public BodyParser<String> text() {
        return this.text(this.DefaultMaxTextLength());
    }

    public static BodyParser byteString$(PlayBodyParsers $this, long maxLength) {
        return $this.byteString(maxLength);
    }

    default public BodyParser<ByteString> byteString(long maxLength) {
        return this.tolerantBodyParser("byteString", maxLength, "Error decoding byte string body", (Function2 & Serializable)(_$10, bytes) -> bytes);
    }

    public static BodyParser byteString$(PlayBodyParsers $this) {
        return $this.byteString();
    }

    default public BodyParser<ByteString> byteString() {
        return this.byteString(this.config().maxMemoryBuffer());
    }

    public static BodyParser raw$(PlayBodyParsers $this, long memoryThreshold, long maxLength) {
        return $this.raw(memoryThreshold, maxLength);
    }

    default public BodyParser<RawBuffer> raw(long memoryThreshold, long maxLength) {
        return BodyParser$.MODULE$.apply("raw, memoryThreshold=" + memoryThreshold, (Function1 & Serializable)request -> {
            RawBuffer buffer2 = RawBuffer$.MODULE$.apply(memoryThreshold, this.temporaryFileCreator(), RawBuffer$.MODULE$.$lessinit$greater$default$3());
            Sink sink = Sink$.MODULE$.fold((Object)buffer2, (Function2 & Serializable)(bf, bs) -> {
                bf.push((ByteString)bs);
                return bf;
            });
            return this.enforceMaxLength((RequestHeader)request, maxLength, (Accumulator)Accumulator$.MODULE$.strict((Function1 & Serializable)maybeStrictBytes -> Future$.MODULE$.successful((Object)RawBuffer$.MODULE$.apply(memoryThreshold, this.temporaryFileCreator(), (ByteString)maybeStrictBytes.getOrElse(PlayBodyParsers::raw$$anonfun$1$$anonfun$1$$anonfun$1))), sink.mapMaterializedValue((Function1 & Serializable)future -> future.andThen((PartialFunction)new Serializable(buffer2){
                private final RawBuffer buffer$2;
                {
                    this.buffer$2 = buffer$3;
                }

                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    return true;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Try try_ = x;
                    this.buffer$2.close();
                    return BoxedUnit.UNIT;
                }
            }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline()))).map((Function1 & Serializable)buffer -> package$.MODULE$.Right().apply(buffer), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline()));
        });
    }

    public static long raw$default$1$(PlayBodyParsers $this) {
        return $this.raw$default$1();
    }

    default public long raw$default$1() {
        return this.DefaultMaxTextLength();
    }

    public static long raw$default$2$(PlayBodyParsers $this) {
        return $this.raw$default$2();
    }

    default public long raw$default$2() {
        return this.DefaultMaxDiskLength();
    }

    public static BodyParser raw$(PlayBodyParsers $this) {
        return $this.raw();
    }

    default public BodyParser<RawBuffer> raw() {
        return this.raw(this.raw$default$1(), this.raw$default$2());
    }

    public static BodyParser tolerantJson$(PlayBodyParsers $this, long maxLength) {
        return $this.tolerantJson(maxLength);
    }

    default public BodyParser<JsValue> tolerantJson(long maxLength) {
        return this.tolerantBodyParser("json", maxLength, "Invalid Json", (Function2 & Serializable)(request, bytes) -> Json$.MODULE$.parse(bytes.iterator().asInputStream()));
    }

    public static BodyParser tolerantJson$(PlayBodyParsers $this) {
        return $this.tolerantJson();
    }

    default public BodyParser<JsValue> tolerantJson() {
        return this.tolerantJson(this.DefaultMaxTextLength());
    }

    public static BodyParser tolerantJson$(PlayBodyParsers $this, Reads reader) {
        return $this.tolerantJson(reader);
    }

    default public <A> BodyParser<A> tolerantJson(Reads<A> reader) {
        return this.jsonReads(this.tolerantJson(), reader);
    }

    public static BodyParser json$(PlayBodyParsers $this, long maxLength) {
        return $this.json(maxLength);
    }

    default public BodyParser<JsValue> json(long maxLength) {
        return this.when((Function1<RequestHeader, Object>)(Function1 & Serializable)_$11 -> _$11.contentType().exists((Function1 & Serializable)m -> m.equalsIgnoreCase("text/json") || m.equalsIgnoreCase("application/json")), this.tolerantJson(maxLength), this.createBadResult("Expecting text/json or application/json body", Status$.MODULE$.UNSUPPORTED_MEDIA_TYPE()));
    }

    public static BodyParser json$(PlayBodyParsers $this) {
        return $this.json();
    }

    default public BodyParser<JsValue> json() {
        return this.json(this.DefaultMaxTextLength());
    }

    public static BodyParser json$(PlayBodyParsers $this, Reads reader) {
        return $this.json(reader);
    }

    default public <A> BodyParser<A> json(Reads<A> reader) {
        return this.jsonReads(this.json(), reader);
    }

    private <A> BodyParser<A> jsonReads(BodyParser<JsValue> parser, Reads<A> reader) {
        return BodyParser$.MODULE$.apply("json reader", (Function1 & Serializable)request -> ((Accumulator)parser.apply(request)).mapFuture((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Result simpleResult = (Result)((Left)either).value();
                return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)simpleResult));
            }
            if (either instanceof Right) {
                JsValue jsValue = (JsValue)((Right)either).value();
                return (Future)jsValue.validate(reader).map((Function1 & Serializable)a -> Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply(a))).recoverTotal((Function1 & Serializable)jsError -> {
                    String msg = "Json validation error " + JsError$.MODULE$.toFlatForm(jsError);
                    return ((Future)this.createBadResult(msg, this.createBadResult$default$2()).apply(request)).map((Function1 & Serializable)value -> package$.MODULE$.Left().apply(value), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
                });
            }
            throw new MatchError((Object)either);
        }, (ExecutionContext)Execution$Implicits$.MODULE$.trampoline()));
    }

    public static BodyParser form$(PlayBodyParsers $this, Form form2, Option maxLength, Function1 onErrors) {
        return $this.form(form2, (Option<Object>)maxLength, onErrors);
    }

    default public <A> BodyParser<A> form(Form<A> form2, Option<Object> maxLength, Function1<Form<A>, Result> onErrors) {
        return BodyParser$.MODULE$.apply((Function1 & Serializable)requestHeader -> {
            BodyParser<AnyContent> parser = this.anyContent(maxLength);
            FormBinding binding = this.formBinding(BoxesRunTime.unboxToLong((Object)maxLength.getOrElse(this::$anonfun$8)), this.formBinding$default$2());
            return ((Accumulator)parser.apply(requestHeader)).map((Function1 & Serializable)resultOrBody -> resultOrBody.flatMap((Function1 & Serializable)body -> (Either)form2.bindFromRequest(Request$.MODULE$.apply((RequestHeader)requestHeader, body), binding).fold((Function1 & Serializable)formErrors -> package$.MODULE$.Left().apply(onErrors.apply(formErrors)), (Function1 & Serializable)a -> package$.MODULE$.Right().apply(a))), (ExecutionContext)Execution$.MODULE$.trampoline());
        });
    }

    public static Option form$default$2$(PlayBodyParsers $this) {
        return $this.form$default$2();
    }

    default public <A> Option<Object> form$default$2() {
        return None$.MODULE$;
    }

    public static Function1 form$default$3$(PlayBodyParsers $this) {
        return $this.form$default$3();
    }

    default public <A> Function1<Form<A>, Result> form$default$3() {
        return (Function1 & Serializable)_$12 -> Results$.MODULE$.BadRequest();
    }

    public static BodyParser tolerantXml$(PlayBodyParsers $this, long maxLength) {
        return $this.tolerantXml(maxLength);
    }

    default public BodyParser<NodeSeq> tolerantXml(long maxLength) {
        return this.tolerantBodyParser("xml", maxLength, "Invalid XML", (Function2 & Serializable)(request, bytes) -> {
            InputSource inputSource = new InputSource(bytes.iterator().asInputStream());
            request.charset().orElse(() -> PlayBodyParsers.tolerantXml$$anonfun$1$$anonfun$1(request)).foreach((Function1)(JProcedure1 & Serializable)charset -> inputSource.setEncoding((String)charset));
            return Play$.MODULE$.XML().load(inputSource);
        });
    }

    public static BodyParser tolerantXml$(PlayBodyParsers $this) {
        return $this.tolerantXml();
    }

    default public BodyParser<NodeSeq> tolerantXml() {
        return this.tolerantXml(this.DefaultMaxTextLength());
    }

    public static BodyParser xml$(PlayBodyParsers $this, long maxLength) {
        return $this.xml(maxLength);
    }

    default public BodyParser<NodeSeq> xml(long maxLength) {
        return this.when((Function1<RequestHeader, Object>)(Function1 & Serializable)_$13 -> _$13.contentType().exists((Function1 & Serializable)t -> {
            String tl = t.toLowerCase(Locale.ENGLISH);
            return tl.startsWith("text/xml") || tl.startsWith("application/xml") || this.ApplicationXmlMatcher().pattern().matcher(tl).matches();
        }), this.tolerantXml(maxLength), this.createBadResult("Expecting xml body", Status$.MODULE$.UNSUPPORTED_MEDIA_TYPE()));
    }

    public static BodyParser xml$(PlayBodyParsers $this) {
        return $this.xml();
    }

    default public BodyParser<NodeSeq> xml() {
        return this.xml(this.DefaultMaxTextLength());
    }

    public static BodyParser file$(PlayBodyParsers $this, File to, long maxLength) {
        return $this.file(to, maxLength);
    }

    default public BodyParser<File> file(File to, long maxLength) {
        return BodyParser$.MODULE$.apply("file, to=" + to, (Function1 & Serializable)request -> {
            Accumulator bodyAccumulator = Accumulator$.MODULE$.apply(StreamConverters$.MODULE$.fromOutputStream((Function0 & Serializable)() -> Files.newOutputStream(to.toPath(), new OpenOption[0]), StreamConverters$.MODULE$.fromOutputStream$default$2())).map((Function1 & Serializable)_$14 -> package$.MODULE$.Right().apply((Object)to), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            return this.enforceMaxLength((RequestHeader)request, maxLength, (Accumulator)bodyAccumulator);
        });
    }

    public static BodyParser file$(PlayBodyParsers $this, File to) {
        return $this.file(to);
    }

    default public BodyParser<File> file(File to) {
        return this.file(to, this.DefaultMaxDiskLength());
    }

    private Future<Left<Result, Nothing$>> requestEntityTooLarge(RequestHeader request) {
        return ((Future)this.createBadResult("Request Entity Too Large", Status$.MODULE$.REQUEST_ENTITY_TOO_LARGE()).apply((Object)request)).map((Function1 & Serializable)_$15 -> package$.MODULE$.Left().apply(_$15), (ExecutionContext)Execution$.MODULE$.trampoline());
    }

    public static BodyParser temporaryFile$(PlayBodyParsers $this, long maxLength) {
        return $this.temporaryFile(maxLength);
    }

    default public BodyParser<Files.TemporaryFile> temporaryFile(long maxLength) {
        return BodyParser$.MODULE$.apply("temporaryFile", (Function1 & Serializable)request -> {
            if (BodyParserUtils$.MODULE$.contentLengthHeaderExceedsMaxLength((RequestHeader)request, maxLength)) {
                return Accumulator$.MODULE$.done(this.requestEntityTooLarge((RequestHeader)request));
            }
            Files.TemporaryFile tempFile = this.temporaryFileCreator().create("requestBody", "asTemporaryFile");
            return ((Accumulator)this.file(Files$TemporaryFile$.MODULE$.temporaryFileToFile(tempFile), maxLength).apply(request)).map((Function1 & Serializable)_$16 -> (Either)_$16.fold((Function1 & Serializable)result -> package$.MODULE$.Left().apply(result), (Function1 & Serializable)_$17 -> package$.MODULE$.Right().apply((Object)tempFile)), (ExecutionContext)Execution$.MODULE$.trampoline());
        });
    }

    public static BodyParser temporaryFile$(PlayBodyParsers $this) {
        return $this.temporaryFile();
    }

    default public BodyParser<Files.TemporaryFile> temporaryFile() {
        return this.temporaryFile(this.DefaultMaxDiskLength());
    }

    public static BodyParser tolerantFormUrlEncoded$(PlayBodyParsers $this, long maxLength) {
        return $this.tolerantFormUrlEncoded(maxLength);
    }

    default public BodyParser<Map<String, Seq<String>>> tolerantFormUrlEncoded(long maxLength) {
        return this.tolerantBodyParser("formUrlEncoded", maxLength, "Error parsing application/x-www-form-urlencoded", (Function2 & Serializable)(request, bytes) -> {
            String charset = (String)request.charset().getOrElse(PlayBodyParsers::$anonfun$11);
            String urlEncodedString = bytes.decodeString("UTF-8");
            return FormUrlEncodedParser$.MODULE$.parse(urlEncodedString, charset);
        });
    }

    public static BodyParser tolerantFormUrlEncoded$(PlayBodyParsers $this) {
        return $this.tolerantFormUrlEncoded();
    }

    default public BodyParser<Map<String, Seq<String>>> tolerantFormUrlEncoded() {
        return this.tolerantFormUrlEncoded(this.DefaultMaxTextLength());
    }

    public static BodyParser formUrlEncoded$(PlayBodyParsers $this, long maxLength) {
        return $this.formUrlEncoded(maxLength);
    }

    default public BodyParser<Map<String, Seq<String>>> formUrlEncoded(long maxLength) {
        return this.when((Function1<RequestHeader, Object>)(Function1 & Serializable)_$18 -> _$18.contentType().exists((Function1 & Serializable)_$19 -> _$19.equalsIgnoreCase("application/x-www-form-urlencoded")), this.tolerantFormUrlEncoded(maxLength), this.createBadResult("Expecting application/x-www-form-urlencoded body", Status$.MODULE$.UNSUPPORTED_MEDIA_TYPE()));
    }

    public static BodyParser formUrlEncoded$(PlayBodyParsers $this) {
        return $this.formUrlEncoded();
    }

    default public BodyParser<Map<String, Seq<String>>> formUrlEncoded() {
        return this.formUrlEncoded(this.DefaultMaxTextLength());
    }

    public static BodyParser default$(PlayBodyParsers $this) {
        return $this.default();
    }

    default public BodyParser<AnyContent> default() {
        return this.default((Option<Object>)None$.MODULE$);
    }

    public static BodyParser defaultBodyParser$(PlayBodyParsers $this) {
        return $this.defaultBodyParser();
    }

    default public BodyParser<AnyContent> defaultBodyParser() {
        return this.default();
    }

    public static BodyParser default$(PlayBodyParsers $this, Option maxLength) {
        return $this.default((Option<Object>)maxLength);
    }

    default public BodyParser<AnyContent> default(Option<Object> maxLength) {
        return this.using((Function1 & Serializable)request -> {
            if (request.hasBody()) {
                return this.anyContent(maxLength);
            }
            return this.ignore(AnyContentAsEmpty$.MODULE$);
        });
    }

    public static BodyParser anyContent$(PlayBodyParsers $this) {
        return $this.anyContent();
    }

    default public BodyParser<AnyContent> anyContent() {
        return this.anyContent((Option<Object>)None$.MODULE$);
    }

    public static BodyParser anyContent$(PlayBodyParsers $this, Option maxLength) {
        return $this.anyContent((Option<Object>)maxLength);
    }

    default public BodyParser<AnyContent> anyContent(Option<Object> maxLength) {
        return BodyParser$.MODULE$.apply("anyContent", (Function1 & Serializable)request -> {
            String string;
            List list;
            Option option;
            String string2;
            Option contentType = request.contentType().map((Function1 & Serializable)_$20 -> _$20.toLowerCase(Locale.ENGLISH));
            Option option2 = contentType;
            if (option2 instanceof Some && "text/plain".equals(((Some)option2).value())) {
                this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$1, MarkerContext$.MODULE$.NoMarker());
                return ((Accumulator)this.text(this.maxLengthOrDefault$1(maxLength)).apply(request)).map((Function1 & Serializable)_$21 -> _$21.map((Function1 & Serializable)s -> (AnyContent)(s == null || s.isEmpty() ? AnyContentAsEmpty$.MODULE$ : AnyContentAsText$.MODULE$.apply((String)s))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            if (option2 instanceof Some && ("text/xml".equals(string2 = (String)((Some)option2).value()) || "application/xml".equals(string2) || string2 != null && !(option = this.ApplicationXmlMatcher().unapplySeq((CharSequence)string2)).isEmpty() && (list = (List)option.get()).lengthCompare(0) == 0)) {
                this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$3, MarkerContext$.MODULE$.NoMarker());
                return ((Accumulator)this.xml(this.maxLengthOrDefault$1(maxLength)).apply(request)).map((Function1 & Serializable)_$22 -> _$22.map((Function1 & Serializable)x -> (AnyContent)(x == null || x.isEmpty() ? AnyContentAsEmpty$.MODULE$ : AnyContentAsXml$.MODULE$.apply((NodeSeq)x))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            if (option2 instanceof Some && ("text/json".equals(string = (String)((Some)option2).value()) || "application/json".equals(string))) {
                this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$5, MarkerContext$.MODULE$.NoMarker());
                return ((Accumulator)this.json(this.maxLengthOrDefault$1(maxLength)).apply(request)).map((Function1 & Serializable)_$23 -> _$23.map((Function1 & Serializable)j -> AnyContentAsJson$.MODULE$.apply((JsValue)j)), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            if (option2 instanceof Some) {
                String string3 = (String)((Some)option2).value();
                if ("application/x-www-form-urlencoded".equals(string3)) {
                    this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$7, MarkerContext$.MODULE$.NoMarker());
                    return ((Accumulator)this.formUrlEncoded(this.maxLengthOrDefault$1(maxLength)).apply(request)).map((Function1 & Serializable)_$24 -> _$24.map((Function1 & Serializable)d -> (AnyContent)(d == null || d.isEmpty() ? AnyContentAsEmpty$.MODULE$ : AnyContentAsFormUrlEncoded$.MODULE$.apply((Map<String, Seq<String>>)d))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
                }
                if ("multipart/form-data".equals(string3)) {
                    this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$9, MarkerContext$.MODULE$.NoMarker());
                    return ((Accumulator)this.multipartFormData(Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.temporaryFileCreator()), this.maxLengthOrDefaultLarge$1(maxLength), this.DefaultAllowEmptyFileUploads()).apply(request)).map((Function1 & Serializable)_$25 -> _$25.map((Function1 & Serializable)m -> (AnyContent)(m == null || m.isEmpty() ? AnyContentAsEmpty$.MODULE$ : AnyContentAsMultipartFormData$.MODULE$.apply((MultipartFormData<Files.TemporaryFile>)m))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
                }
            }
            this.play$api$mvc$PlayBodyParsers$$logger().trace(PlayBodyParsers::anyContent$$anonfun$1$$anonfun$11, MarkerContext$.MODULE$.NoMarker());
            return ((Accumulator)this.raw(this.DefaultMaxTextLength(), this.maxLengthOrDefaultLarge$1(maxLength)).apply(request)).map((Function1 & Serializable)_$26 -> _$26.map((Function1 & Serializable)r -> (AnyContent)(r == null || r.size() == 0L ? AnyContentAsEmpty$.MODULE$ : AnyContentAsRaw$.MODULE$.apply((RawBuffer)r))), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
        });
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this) {
        return $this.multipartFormData();
    }

    default public BodyParser<MultipartFormData<Files.TemporaryFile>> multipartFormData() {
        return this.multipartFormData(Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.temporaryFileCreator()), this.multipartFormData$default$2(), this.multipartFormData$default$3());
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this, long maxLength) {
        return $this.multipartFormData(maxLength);
    }

    default public BodyParser<MultipartFormData<Files.TemporaryFile>> multipartFormData(long maxLength) {
        return this.multipartFormData(Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.temporaryFileCreator()), maxLength, false);
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this, boolean allowEmptyFiles) {
        return $this.multipartFormData(allowEmptyFiles);
    }

    default public BodyParser<MultipartFormData<Files.TemporaryFile>> multipartFormData(boolean allowEmptyFiles) {
        Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<Files.TemporaryFile>>> function1 = Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.temporaryFileCreator());
        long l = this.multipartFormData$default$2();
        return this.multipartFormData(function1, l, allowEmptyFiles);
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this, long maxLength, boolean allowEmptyFiles) {
        return $this.multipartFormData(maxLength, allowEmptyFiles);
    }

    default public BodyParser<MultipartFormData<Files.TemporaryFile>> multipartFormData(long maxLength, boolean allowEmptyFiles) {
        return this.multipartFormData(Multipart$.MODULE$.handleFilePartAsTemporaryFile(this.temporaryFileCreator()), maxLength, allowEmptyFiles);
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this, Function1 filePartHandler, long maxLength) {
        return $this.multipartFormData(filePartHandler, maxLength);
    }

    default public <A> BodyParser<MultipartFormData<A>> multipartFormData(Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, long maxLength) {
        return this.multipartFormData(filePartHandler, maxLength, false);
    }

    public static BodyParser multipartFormData$(PlayBodyParsers $this, Function1 filePartHandler, long maxLength, boolean allowEmptyFiles) {
        return $this.multipartFormData(filePartHandler, maxLength, allowEmptyFiles);
    }

    default public <A> BodyParser<MultipartFormData<A>> multipartFormData(Function1<Multipart.FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> filePartHandler, long maxLength, boolean allowEmptyFiles) {
        return BodyParser$.MODULE$.apply("multipartFormData", (Function1 & Serializable)request -> {
            Accumulator bodyAccumulator = (Accumulator)Multipart$.MODULE$.multipartParser(this.DefaultMaxTextLength(), allowEmptyFiles, filePartHandler, this.errorHandler(), this.materializer()).apply(request);
            return this.enforceMaxLength((RequestHeader)request, maxLength, (Accumulator)bodyAccumulator);
        });
    }

    public static long multipartFormData$default$2$(PlayBodyParsers $this) {
        return $this.multipartFormData$default$2();
    }

    default public long multipartFormData$default$2() {
        return this.DefaultMaxDiskLength();
    }

    public static boolean multipartFormData$default$3$(PlayBodyParsers $this) {
        return $this.multipartFormData$default$3();
    }

    default public boolean multipartFormData$default$3() {
        return this.DefaultAllowEmptyFileUploads();
    }

    public static Function1 createBadResult$(PlayBodyParsers $this, String msg, int statusCode) {
        return $this.createBadResult(msg, statusCode);
    }

    default public Function1<RequestHeader, Future<Result>> createBadResult(String msg, int statusCode) {
        return (Function1 & Serializable)request -> this.errorHandler().onClientError((RequestHeader)request, statusCode, msg);
    }

    public static int createBadResult$default$2$(PlayBodyParsers $this) {
        return $this.createBadResult$default$2();
    }

    default public int createBadResult$default$2() {
        return Status$.MODULE$.BAD_REQUEST();
    }

    public static Accumulator enforceMaxLength$(PlayBodyParsers $this, RequestHeader request, long maxLength, Accumulator accumulator) {
        return $this.enforceMaxLength(request, maxLength, accumulator);
    }

    default public <A> Accumulator<ByteString, Either<Result, A>> enforceMaxLength(RequestHeader request, long maxLength, Accumulator<ByteString, Either<Result, A>> accumulator) {
        if (BodyParserUtils$.MODULE$.contentLengthHeaderExceedsMaxLength(request, maxLength)) {
            return Accumulator$.MODULE$.done(this.requestEntityTooLarge(request));
        }
        Flow takeUpToFlow = Flow$.MODULE$.fromGraph((Graph)new BodyParsers.TakeUpTo(maxLength));
        return Accumulator$.MODULE$.apply(takeUpToFlow.toMat((Graph)accumulator.toSink(), (Function2 & Serializable)(statusFuture, resultFuture) -> statusFuture.flatMap((Function1 & Serializable)x$1 -> {
            MaxSizeStatus maxSizeStatus = x$1;
            if (maxSizeStatus instanceof MaxSizeExceeded) {
                MaxSizeExceeded maxSizeExceeded = MaxSizeExceeded$.MODULE$.unapply((MaxSizeExceeded)maxSizeStatus);
                long l = maxSizeExceeded._1();
                return this.requestEntityTooLarge(request);
            }
            if (MaxSizeNotExceeded$.MODULE$.equals(maxSizeStatus)) {
                return resultFuture;
            }
            throw new MatchError((Object)maxSizeStatus);
        }, (ExecutionContext)Execution$.MODULE$.trampoline())));
    }

    public static BodyParser tolerantBodyParser$(PlayBodyParsers $this, String name, long maxLength, String errorMessage, Function2 parser) {
        return $this.tolerantBodyParser(name, maxLength, errorMessage, parser);
    }

    default public <A> BodyParser<A> tolerantBodyParser(String name, long maxLength, String errorMessage, Function2<RequestHeader, ByteString, A> parser) {
        return BodyParser$.MODULE$.apply(name + ", maxLength=" + maxLength, (Function1 & Serializable)request -> {
            if (BodyParserUtils$.MODULE$.contentLengthHeaderExceedsMaxLength((RequestHeader)request, maxLength)) {
                return Accumulator$.MODULE$.done(this.requestEntityTooLarge((RequestHeader)request));
            }
            return Accumulator$.MODULE$.strict((Function1 & Serializable)x$1 -> {
                ByteString bytes;
                Option option = x$1;
                if (option instanceof Some && (long)(bytes = (ByteString)((Some)option).value()).size() <= maxLength) {
                    return this.parseBody$1(parser, (RequestHeader)request, errorMessage, bytes);
                }
                if (None$.MODULE$.equals(option)) {
                    return this.parseBody$1(parser, (RequestHeader)request, errorMessage, ByteString$.MODULE$.empty());
                }
                return this.requestEntityTooLarge((RequestHeader)request);
            }, this.enforceMaxLength((RequestHeader)request, maxLength, (Accumulator)Accumulator$.MODULE$.apply(Sink$.MODULE$.fold((Object)ByteString$.MODULE$.empty(), (Function2 & Serializable)(state, bs) -> state.$plus$plus(bs))).mapFuture((Function1 & Serializable)bytes -> this.parseBody$1(parser, (RequestHeader)request, errorMessage, (ByteString)bytes), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline())).toSink());
        });
    }

    private static String decode$1$$anonfun$1(RequestHeader request$3, Charset encodingToTry$1) {
        return "TolerantText body parser tried to parse request " + request$3.id() + " as text body with charset " + encodingToTry$1 + ", but it contains invalid characters!";
    }

    private static String decode$1$$anonfun$2() {
        return "Unexpected exception while decoding text/plain body";
    }

    private static Throwable decode$1$$anonfun$3(Exception e$1) {
        return e$1;
    }

    public static Try play$api$mvc$PlayBodyParsers$$_$decode$1$(PlayBodyParsers $this, ByteBuffer byteBuffer$1, RequestHeader request$2, Charset encodingToTry) {
        return $this.play$api$mvc$PlayBodyParsers$$_$decode$1(byteBuffer$1, request$2, encodingToTry);
    }

    default public Try play$api$mvc$PlayBodyParsers$$_$decode$1(ByteBuffer byteBuffer$1, RequestHeader request$2, Charset encodingToTry) {
        Success success;
        CharsetDecoder decoder = encodingToTry.newDecoder().onMalformedInput(CodingErrorAction.REPORT);
        try {
            byteBuffer$1.rewind();
            success = Success$.MODULE$.apply((Object)decoder.decode(byteBuffer$1).toString());
        }
        catch (CharacterCodingException e) {
            this.play$api$mvc$PlayBodyParsers$$logger().warn(() -> PlayBodyParsers.decode$1$$anonfun$1(request$2, encodingToTry), MarkerContext$.MODULE$.NoMarker());
            success = Failure$.MODULE$.apply((Throwable)e);
        }
        catch (Exception e) {
            this.play$api$mvc$PlayBodyParsers$$logger().error(PlayBodyParsers::decode$1$$anonfun$2, () -> PlayBodyParsers.decode$1$$anonfun$3(e), MarkerContext$.MODULE$.NoMarker());
            success = Failure$.MODULE$.apply((Throwable)e);
        }
        return success;
    }

    private static Charset $anonfun$2() {
        return StandardCharsets.US_ASCII;
    }

    private static String tolerantText$$anonfun$1$$anonfun$1(ByteString bytes$1, Charset charset$1) {
        return bytes$1.decodeString(charset$1);
    }

    private static Charset $anonfun$5() {
        return StandardCharsets.US_ASCII;
    }

    private static String $anonfun$4$$anonfun$1(RequestHeader request$4, Charset charset$2) {
        return "Text body parser tried to parse request " + request$4.id() + " as text body with charset " + charset$2 + ", but it contains invalid characters!";
    }

    private static ByteString raw$$anonfun$1$$anonfun$1$$anonfun$1() {
        return ByteString$.MODULE$.empty();
    }

    public static Accumulator raw$$anonfun$1$(PlayBodyParsers $this, long maxLength$5, long memoryThreshold$1, RequestHeader request) {
        return $this.raw$$anonfun$1(maxLength$5, memoryThreshold$1, request);
    }

    private long $anonfun$8() {
        return this.DefaultMaxTextLength();
    }

    private static Option tolerantXml$$anonfun$1$$anonfun$1(RequestHeader request$7) {
        return request$7.mediaType().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(MediaType x) {
                MediaType mediaType;
                MediaType mt = mediaType = x;
                String string = mt.mediaType();
                String string2 = "text";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }

            public final Object applyOrElse(MediaType x, Function1 function1) {
                MediaType mediaType;
                MediaType mt = mediaType = x;
                String string = mt.mediaType();
                String string2 = "text";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return "iso-8859-1";
                }
                return function1.apply((Object)x);
            }
        });
    }

    private static String $anonfun$11() {
        return "UTF-8";
    }

    private long maxLengthOrDefault$1$$anonfun$1() {
        return this.DefaultMaxTextLength();
    }

    private long maxLengthOrDefault$1(Option maxLength$11) {
        return BoxesRunTime.unboxToLong((Object)maxLength$11.getOrElse(this::maxLengthOrDefault$1$$anonfun$1));
    }

    private long maxLengthOrDefaultLarge$1$$anonfun$1() {
        return this.DefaultMaxDiskLength();
    }

    private long maxLengthOrDefaultLarge$1(Option maxLength$12) {
        return BoxesRunTime.unboxToLong((Object)maxLength$12.getOrElse(this::maxLengthOrDefaultLarge$1$$anonfun$1));
    }

    private static String anyContent$$anonfun$1$$anonfun$1() {
        return "Parsing AnyContent as text";
    }

    private static String anyContent$$anonfun$1$$anonfun$3() {
        return "Parsing AnyContent as xml";
    }

    private static String anyContent$$anonfun$1$$anonfun$5() {
        return "Parsing AnyContent as json";
    }

    private static String anyContent$$anonfun$1$$anonfun$7() {
        return "Parsing AnyContent as urlFormEncoded";
    }

    private static String anyContent$$anonfun$1$$anonfun$9() {
        return "Parsing AnyContent as multipartFormData";
    }

    private static String anyContent$$anonfun$1$$anonfun$11() {
        return "Parsing AnyContent as raw";
    }

    private static String parseBody$1$$anonfun$1(String errorMessage$3) {
        return errorMessage$3;
    }

    private static Throwable parseBody$1$$anonfun$2(Throwable e$2) {
        return e$2;
    }

    private Future parseBody$1(Function2 parser$5, RequestHeader request$10, String errorMessage$2, ByteString bytes) {
        Future future;
        try {
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply(parser$5.apply((Object)request$10, (Object)bytes)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.play$api$mvc$PlayBodyParsers$$logger().debug(() -> PlayBodyParsers.parseBody$1$$anonfun$1(errorMessage$2), () -> PlayBodyParsers.parseBody$1$$anonfun$2(e), MarkerContext$.MODULE$.NoMarker());
                future = ((Future)this.createBadResult(errorMessage$2 + ": " + e.getMessage(), this.createBadResult$default$2()).apply((Object)request$10)).map((Function1 & Serializable)_$27 -> package$.MODULE$.Left().apply(_$27), (ExecutionContext)Execution$Implicits$.MODULE$.trampoline());
            }
            throw throwable;
        }
        return future;
    }
}

