/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import controllers.Assets$;
import controllers.AssetsConfiguration;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.time.Instant;
import java.util.Date;
import play.api.http.AcceptEncoding;
import play.api.http.ContentEncoding$;
import play.api.http.ContentTypes$;
import play.api.http.FileMimeTypes;
import play.api.libs.Codecs$;
import play.api.mvc.ResponseHeader$;
import play.utils.Resources$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.java8.JFunction1;

public class AssetInfo {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AssetInfo.class.getDeclaredField("parsedLastModified$lzy1"));
    private final String name;
    private final URL url;
    private final Seq compressedUrls;
    private final Option digest;
    private final AssetsConfiguration config;
    private final Seq<String> encodingNames;
    private final Map<String, URL> encodingsByName;
    private final boolean varyEncoding;
    private final Option configuredCacheControl;
    private final Option lastModified;
    private final Option etag;
    private final String mimeType;
    private volatile Object parsedLastModified$lzy1;

    /*
     * Unable to fully structure code
     */
    public AssetInfo(String name, URL url, Seq<Tuple2<String, URL>> compressedUrls, Option<String> digest, AssetsConfiguration config, FileMimeTypes fileMimeTypes) {
        block9: {
            this.name = name;
            this.url = url;
            this.compressedUrls = compressedUrls;
            this.digest = digest;
            this.config = config;
            super();
            this.encodingNames = (Seq)compressedUrls.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$1(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/String;)());
            this.encodingsByName = compressedUrls.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.varyEncoding = compressedUrls.nonEmpty();
            this.configuredCacheControl = config.findConfiguredCacheControl(name);
            var7_7 = this.url().getProtocol();
            switch (var7_7 == null ? 0 : var7_7.hashCode()) {
                case -1377881982: {
                    if (!"bundle".equals(var7_7)) {
                        break;
                    }
                    ** GOTO lbl31
                }
                case -341064690: {
                    if (!"resource".equals(var7_7)) {
                        break;
                    }
                    ** GOTO lbl31
                }
                case 104987: {
                    if (!"jar".equals(var7_7)) break;
                    v0 = this.getLastModified$1((Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$2(java.net.JarURLConnection ), (Ljava/net/JarURLConnection;)J)());
                    break block9;
                }
                case 3143036: {
                    if (!"file".equals(var7_7)) break;
                    v0 = Some$.MODULE$.apply((Object)ResponseHeader$.MODULE$.httpDateFormat().format(Instant.ofEpochMilli(new File(this.url().toURI()).lastModified())));
                    break block9;
                }
                case 1780175504: {
                    if (!"bundleresource".equals(var7_7)) break;
lbl31:
                    // 3 sources

                    v0 = this.getLastModified$1((Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$3(java.net.URLConnection ), (Ljava/net/URLConnection;)J)());
                    break block9;
                }
            }
            v0 = None$.MODULE$;
        }
        this.lastModified = v0;
        this.etag = digest.orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$4(), ()Lscala/Option;)((AssetInfo)this)).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$5(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)());
        this.mimeType = (String)fileMimeTypes.forFileName(name).fold((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $init$$$anonfun$6(), ()Ljava/lang/String;)(), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $init$$$anonfun$7(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((AssetInfo)this));
    }

    public String name() {
        return this.name;
    }

    public URL url() {
        return this.url;
    }

    public Seq<Tuple2<String, URL>> compressedUrls() {
        return this.compressedUrls;
    }

    public Option<String> digest() {
        return this.digest;
    }

    public boolean varyEncoding() {
        return this.varyEncoding;
    }

    private boolean isText(String mimeType) {
        String string = mimeType.trim();
        String text = string;
        if (text.startsWith("text/")) {
            return true;
        }
        String text2 = string;
        return this.config.textContentTypes().contains((Object)text2);
    }

    public String addCharsetIfNeeded(String mimeType) {
        if (this.isText(mimeType)) {
            return mimeType + "; charset=" + this.config.defaultCharSet();
        }
        return mimeType;
    }

    public Option<String> configuredCacheControl() {
        return this.configuredCacheControl;
    }

    public String cacheControl(boolean aggressiveCaching) {
        return (String)this.configuredCacheControl().getOrElse(() -> this.cacheControl$$anonfun$1(aggressiveCaching));
    }

    public Option<String> lastModified() {
        return this.lastModified;
    }

    public Option<String> etag() {
        return this.etag;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public Option<Date> parsedLastModified() {
        Object object = this.parsedLastModified$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.parsedLastModified$lzyINIT1();
    }

    private Object parsedLastModified$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.parsedLastModified$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = this.lastModified().flatMap((Function1 & Serializable)date -> Assets$.MODULE$.parseModifiedDate((String)date));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.parsedLastModified$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Option<String> bestEncoding(AcceptEncoding acceptEncoding) {
        return acceptEncoding.preferred(this.encodingNames).filter((Function1 & Serializable)_$8 -> {
            String string = _$8;
            String string2 = ContentEncoding$.MODULE$.Identity();
            return string == null ? string2 != null : !string.equals(string2);
        });
    }

    public URL url(AcceptEncoding acceptEncoding) {
        return (URL)this.bestEncoding(acceptEncoding).flatMap((Function1 & Serializable)key -> this.encodingsByName.get(key)).getOrElse(this::url$$anonfun$2);
    }

    private static final /* synthetic */ String $init$$$anonfun$1(Tuple2 _$6) {
        return (String)_$6._1();
    }

    private static final /* synthetic */ String getLastModified$1$$anonfun$3(long millis) {
        return ResponseHeader$.MODULE$.httpDateFormat().format(Instant.ofEpochMilli(millis));
    }

    private final Option getLastModified$1(Function1 f) {
        return Option$.MODULE$.apply((Object)this.url().openConnection()).map((Function1 & Serializable)x$1 -> {
            URLConnection uRLConnection = x$1;
            if (uRLConnection != null) {
                long l;
                URLConnection urlConnection = uRLConnection;
                try {
                    l = BoxesRunTime.unboxToLong((Object)f.apply((Object)urlConnection));
                }
                finally {
                    Resources$.MODULE$.closeUrlConnection(urlConnection);
                }
                return l;
            }
            throw new MatchError((Object)uRLConnection);
        }).filterNot((Function1)(JFunction1.mcZJ.sp & Serializable)_$7 -> _$7 == -1L).map((Function1 & Serializable)millis -> AssetInfo.getLastModified$1$$anonfun$3(BoxesRunTime.unboxToLong((Object)millis)));
    }

    private static final /* synthetic */ long $init$$$anonfun$2(JarURLConnection c) {
        return c.getJarEntry().getTime();
    }

    private static final /* synthetic */ long $init$$$anonfun$3(URLConnection c) {
        return c.getLastModified();
    }

    private final Option $init$$$anonfun$4() {
        return this.lastModified().map((Function1 & Serializable)m -> Codecs$.MODULE$.sha1(m + " -> " + this.url().toExternalForm()));
    }

    private static final /* synthetic */ String $init$$$anonfun$5(String etag) {
        return "\"" + etag + "\"";
    }

    private static final String $init$$$anonfun$6() {
        return ContentTypes$.MODULE$.BINARY();
    }

    private final /* synthetic */ String $init$$$anonfun$7(String mimeType) {
        return this.addCharsetIfNeeded(mimeType);
    }

    private final String cacheControl$$anonfun$1(boolean aggressiveCaching$1) {
        if (this.config.enableCacheControl()) {
            if (aggressiveCaching$1) {
                return this.config.aggressiveCacheControl();
            }
            return this.config.defaultCacheControl();
        }
        return "no-cache";
    }

    private final URL url$$anonfun$2() {
        return this.url();
    }
}

