/*
 * Decompiled with CFR 0.152.
 */
package play.core.cookie.encoding;

import play.core.cookie.encoding.CookieUtil;

abstract class CookieEncoder {
    private final boolean strict;

    protected CookieEncoder(boolean bl) {
        this.strict = bl;
    }

    protected void validateCookie(String string, String string2) {
        if (this.strict) {
            int n = CookieUtil.firstInvalidCookieNameOctet(string);
            if (n >= 0) {
                throw new IllegalArgumentException("Cookie (" + string + ") contains an invalid char: " + string.charAt(n));
            }
            CharSequence charSequence = CookieUtil.unwrapValue(string2);
            if (charSequence == null) {
                throw new IllegalArgumentException("Cookie (" + string + ") value wrapping quotes are not balanced: " + string2);
            }
            n = CookieUtil.firstInvalidCookieValueOctet(charSequence);
            if (n >= 0) {
                throw new IllegalArgumentException("Cookie (" + string + ") value contains an invalid char: " + string2.charAt(n));
            }
        }
    }
}

