/*
 * Decompiled with CFR 0.152.
 */
package play.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Paths {
    private static String CURRENT_DIR = ".";
    private static String SEPARATOR = "/";
    private static String PARENT_DIR = "..";

    private Paths() {
    }

    public static String relative(String string, String string2) {
        if (string.equals(string2)) {
            return CURRENT_DIR;
        }
        String[] stringArray = Paths.toSegments(Paths.canonical(string));
        String[] stringArray2 = Paths.toSegments(Paths.canonical(string2));
        if (!string.endsWith(SEPARATOR)) {
            stringArray = Arrays.copyOfRange(stringArray, 0, stringArray.length - 1);
        }
        String string3 = "";
        if (!string2.endsWith(SEPARATOR)) {
            string3 = stringArray2[stringArray2.length - 1];
            stringArray2 = Arrays.copyOfRange(stringArray2, 0, stringArray2.length - 1);
        }
        String[] stringArray3 = Paths.commonPrefix(stringArray, stringArray2);
        String[] stringArray4 = Paths.toParentDirs(stringArray.length - stringArray3.length);
        int n = stringArray3.length;
        String[] stringArray5 = Arrays.copyOfRange(stringArray2, n, stringArray2.length);
        String[] stringArray6 = Arrays.copyOf(stringArray4, stringArray4.length + stringArray5.length);
        System.arraycopy(stringArray5, 0, stringArray6, stringArray4.length, stringArray5.length);
        String string4 = "";
        if (stringArray6.length > 0) {
            string4 = SEPARATOR;
        }
        return Arrays.stream(stringArray6).collect(Collectors.joining(SEPARATOR)) + string4 + string3;
    }

    public static String canonical(String string) {
        String[] stringArray = Paths.toSegments(string);
        Stack<String> stack = new Stack<String>();
        for (String string2 : stringArray) {
            if (string2.isEmpty() || string2.equals(CURRENT_DIR)) continue;
            if (!string2.equals(PARENT_DIR) || !stack.empty() && ((String)stack.peek()).equals(PARENT_DIR)) {
                stack.push(string2);
                continue;
            }
            stack.pop();
        }
        String string3 = string.startsWith(SEPARATOR) ? SEPARATOR : "";
        String string4 = string.endsWith(SEPARATOR) ? SEPARATOR : "";
        return string3 + stack.stream().collect(Collectors.joining(SEPARATOR)) + string4;
    }

    private static String[] toSegments(String string2) {
        return (String[])Arrays.stream(string2.split(SEPARATOR)).filter(string -> !string.isEmpty()).toArray(String[]::new);
    }

    private static String[] toParentDirs(int n2) {
        return (String[])IntStream.range(0, n2).mapToObj(n -> PARENT_DIR).toArray(String[]::new);
    }

    private static String[] commonPrefix(String[] stringArray, String[] stringArray2) {
        int n = Math.min(stringArray.length, stringArray2.length);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n && stringArray[i].equals(stringArray2[i]); ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList.toArray(new String[0]);
    }
}

