/*
 * Decompiled with CFR 0.152.
 */
package play.api.i18n;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.http.HttpConfiguration;
import play.api.http.HttpConfiguration$;
import play.api.i18n.DefaultMessagesApi;
import play.api.i18n.Langs;
import play.api.i18n.Messages$;
import play.api.i18n.Messages$UrlMessageSource$;
import play.api.i18n.MessagesApi;
import play.api.mvc.Cookie;
import play.utils.Resources$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

@Singleton
public class DefaultMessagesApiProvider
implements Provider<MessagesApi> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DefaultMessagesApiProvider.class.getDeclaredField("get$lzy1"));
    private final Environment environment;
    private final Configuration config;
    private final Langs langs;
    private HttpConfiguration httpConfiguration;
    private volatile Object get$lzy1;

    @Inject
    public DefaultMessagesApiProvider(Environment environment, Configuration config, Langs langs, HttpConfiguration httpConfiguration) {
        this.environment = environment;
        this.config = config;
        this.langs = langs;
        this.httpConfiguration = httpConfiguration;
    }

    public MessagesApi get() {
        Object object = this.get$lzy1;
        if (object instanceof MessagesApi) {
            return (MessagesApi)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (MessagesApi)this.get$lzyINIT1();
    }

    private Object get$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.get$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    DefaultMessagesApi defaultMessagesApi = null;
                    try {
                        defaultMessagesApi = new DefaultMessagesApi(this.loadAllMessages(), this.langs, this.langCookieName(), this.langCookieSecure(), this.langCookieHttpOnly(), this.langCookieSameSite(), this.httpConfiguration, this.langCookieMaxAge());
                        object2 = defaultMessagesApi == null ? LazyVals.NullValue$.MODULE$ : defaultMessagesApi;
                        this.httpConfiguration = null;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.get$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return defaultMessagesApi;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String langCookieName() {
        return (String)this.config.getDeprecated("play.i18n.langCookieName", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application.lang.cookie"}), ConfigLoader$.MODULE$.stringLoader());
    }

    public boolean langCookieSecure() {
        return BoxesRunTime.unboxToBoolean((Object)this.config.get("play.i18n.langCookieSecure", ConfigLoader$.MODULE$.booleanLoader()));
    }

    public boolean langCookieHttpOnly() {
        return BoxesRunTime.unboxToBoolean((Object)this.config.get("play.i18n.langCookieHttpOnly", ConfigLoader$.MODULE$.booleanLoader()));
    }

    public Option<Cookie.SameSite> langCookieSameSite() {
        return HttpConfiguration$.MODULE$.parseSameSite(this.config, "play.i18n.langCookieSameSite");
    }

    public Option<Object> langCookieMaxAge() {
        return ((Option)this.config.get("play.i18n.langCookieMaxAge", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.finiteDurationLoader()))).map((Function1 & Serializable)_$9 -> (int)_$9.toSeconds());
    }

    public Map<String, Map<String, String>> loadAllMessages() {
        return (Map)this.langs.availables().iterator().map((Function1 & Serializable)lang -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)lang.code());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, this.loadMessages("messages." + lang.code()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).updated((Object)"default", this.loadMessages("messages")).updated((Object)"default.play", this.loadMessages("messages.default"));
    }

    public Map<String, String> loadMessages(String file) {
        return (Map)CollectionConverters$.MODULE$.EnumerationHasAsScala(this.environment.classLoader().getResources(this.joinPaths(this.messagesPrefix(), file))).asScala().toList().filterNot((Function1 & Serializable)url -> Resources$.MODULE$.isDirectory(this.environment.classLoader(), (URL)url)).reverse().map((Function1 & Serializable)messageFile -> {
            String string = messageFile.getProtocol();
            String string2 = "file";
            return (Map)Messages$.MODULE$.parse(Messages$UrlMessageSource$.MODULE$.apply((URL)messageFile), !(string != null ? !string.equals(string2) : string2 != null) ? messageFile.getPath() : messageFile.toString()).fold((Function1 & Serializable)e -> {
                throw e;
            }, (Function1 & Serializable)x -> (Map)Predef$.MODULE$.identity(x));
        }).foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(_$10, _$11) -> (Map)_$10.$plus$plus((IterableOnce)_$11));
    }

    public Option<String> messagesPrefix() {
        return (Option)this.config.getDeprecated("play.i18n.path", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"messages.path"}), ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
    }

    public String joinPaths(Option<String> first, String second) {
        Option<String> option = first;
        if (option instanceof Some) {
            String parent = (String)((Some)option).value();
            return new File(parent, second).getPath();
        }
        if (None$.MODULE$.equals(option)) {
            return second;
        }
        throw new MatchError(option);
    }
}

