/*
 * Decompiled with CFR 0.152.
 */
package play.api.http;

import java.io.Serializable;
import play.api.http.HttpErrorHandler;
import play.api.http.MediaRange$;
import play.api.http.PreferredMediaTypeHttpErrorHandler$;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;

public class PreferredMediaTypeHttpErrorHandler
implements HttpErrorHandler {
    private final Seq handlers;
    private final Seq<String> supportedTypes;
    private final Map<String, HttpErrorHandler> typeToHandler;
    private final HttpErrorHandler defaultHandler;

    public static PreferredMediaTypeHttpErrorHandler apply(Seq<Tuple2<String, HttpErrorHandler>> seq) {
        return PreferredMediaTypeHttpErrorHandler$.MODULE$.apply(seq);
    }

    public PreferredMediaTypeHttpErrorHandler(Seq<Tuple2<String, HttpErrorHandler>> handlers) {
        this.handlers = handlers;
        this.supportedTypes = (Seq)handlers.map((Function1 & Serializable)_$1 -> (String)_$1._1());
        this.typeToHandler = handlers.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.defaultHandler = (HttpErrorHandler)((Tuple2)handlers.headOption().getOrElse(PreferredMediaTypeHttpErrorHandler::$init$$$anonfun$2))._2();
    }

    public Seq<Tuple2<String, HttpErrorHandler>> handlers() {
        return this.handlers;
    }

    public HttpErrorHandler defaultHandler() {
        return this.defaultHandler;
    }

    public HttpErrorHandler preferredHandler(RequestHeader request) {
        return (HttpErrorHandler)MediaRange$.MODULE$.preferred(request.acceptedTypes(), this.supportedTypes).fold(this::preferredHandler$$anonfun$1, this.typeToHandler);
    }

    @Override
    public Future<Result> onClientError(RequestHeader request, int statusCode, String message) {
        return this.preferredHandler(request).onClientError(request, statusCode, message);
    }

    @Override
    public Future<Result> onServerError(RequestHeader request, Throwable exception) {
        return this.preferredHandler(request).onServerError(request, exception);
    }

    private static final Tuple2 $init$$$anonfun$2() {
        throw new IllegalArgumentException("handlers must not be empty");
    }

    private final HttpErrorHandler preferredHandler$$anonfun$1() {
        return this.defaultHandler();
    }
}

