/*
 * Decompiled with CFR 0.152.
 */
package play.i18n;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import play.Application;
import play.api.i18n.Langs;
import play.libs.Scala;

public class Lang
extends play.api.i18n.Lang {
    public Lang(play.api.i18n.Lang lang) {
        super(lang.locale());
    }

    public Lang(Locale locale) {
        this(new play.api.i18n.Lang(locale));
    }

    @Override
    public String language() {
        return this.locale().getLanguage();
    }

    @Override
    public String country() {
        return this.locale().getCountry();
    }

    @Override
    public String script() {
        return this.locale().getScript();
    }

    @Override
    public String variant() {
        return this.locale().getVariant();
    }

    @Override
    public String code() {
        return this.locale().toLanguageTag();
    }

    @Override
    public Locale toLocale() {
        return this.locale();
    }

    public static Lang forCode(String string) {
        try {
            return new Lang(play.api.i18n.Lang.apply(string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Lang> availables(Application application) {
        Langs langs = application.injector().instanceOf(Langs.class);
        List<play.api.i18n.Lang> list = Scala.asJava(langs.availables());
        return list.stream().map(Lang::new).collect(Collectors.toList());
    }

    public static Lang preferred(Application application, List<Lang> list) {
        Langs langs = application.injector().instanceOf(Langs.class);
        Stream stream = list.stream();
        List list2 = stream.map(lang -> new play.api.i18n.Lang(lang.toLocale())).collect(Collectors.toList());
        return new Lang(langs.preferred(Scala.toSeq(list2)));
    }

    public static Lang defaultLang() {
        return play.api.i18n.Lang.defaultLang().asJava();
    }
}

