/*
 * Decompiled with CFR 0.152.
 */
package play.core.parsers;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.FlowShape$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import play.api.http.HttpErrorHandler;
import play.api.libs.Files;
import play.api.libs.streams.Accumulator;
import play.api.mvc.BodyParser;
import play.api.mvc.MultipartFormData;
import play.api.mvc.MultipartFormData$BadPart$;
import play.api.mvc.MultipartFormData$DataPart$;
import play.api.mvc.MultipartFormData$FilePart$;
import play.api.mvc.MultipartFormData$MaxMemoryBufferExceeded$;
import play.api.mvc.MultipartFormData$ParseError$;
import play.api.mvc.Result;
import play.core.parsers.Multipart$;
import play.core.parsers.Multipart$BodyPartParser$ContinueParsing$;
import play.core.parsers.Multipart$BodyPartParser$Done$;
import play.core.parsers.Multipart$FileInfo$;
import play.core.parsers.Multipart$FileInfoMatcher$;
import play.core.parsers.Multipart$NotEnoughDataException$;
import play.core.parsers.Multipart$PartInfoMatcher$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Queue$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class Multipart {
    public static Function1<FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<Files.TemporaryFile>>> handleFilePartAsTemporaryFile(Files.TemporaryFileCreator temporaryFileCreator) {
        return Multipart$.MODULE$.handleFilePartAsTemporaryFile(temporaryFileCreator);
    }

    public static <A> BodyParser<MultipartFormData<A>> multipartParser(long l, boolean bl, Function1<FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> function1, HttpErrorHandler httpErrorHandler, Materializer materializer) {
        return Multipart$.MODULE$.multipartParser(l, bl, function1, httpErrorHandler, materializer);
    }

    public static <A> BodyParser<MultipartFormData<A>> multipartParser(long l, Function1<FileInfo, Accumulator<ByteString, MultipartFormData.FilePart<A>>> function1, HttpErrorHandler httpErrorHandler, Materializer materializer) {
        return Multipart$.MODULE$.multipartParser(l, function1, httpErrorHandler, materializer);
    }

    public static <A> BodyParser<A> partParser(long l, boolean bl, HttpErrorHandler httpErrorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> accumulator, Materializer materializer) {
        return Multipart$.MODULE$.partParser(l, bl, httpErrorHandler, accumulator, materializer);
    }

    public static <A> BodyParser<A> partParser(long l, HttpErrorHandler httpErrorHandler, Accumulator<MultipartFormData.Part<Source<ByteString, ?>>, Either<Result, A>> accumulator, Materializer materializer) {
        return Multipart$.MODULE$.partParser(l, httpErrorHandler, accumulator, materializer);
    }

    public static final class BodyPartParser
    extends GraphStage<FlowShape<ByteString, Either<MultipartFormData.Part<BoxedUnit>, ByteString>>> {
        public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(BodyPartParser.class.getDeclaredField("ContinueParsing$lzy1"));
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BodyPartParser.class.getDeclaredField("Done$lzy1"));
        public final long play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize;
        public final int play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize;
        public final boolean play$core$parsers$Multipart$BodyPartParser$$allowEmptyFiles;
        private volatile Object Done$lzy1;
        private volatile Object ContinueParsing$lzy1;
        public final byte[] play$core$parsers$Multipart$BodyPartParser$$needle;
        public final BoyerMoore play$core$parsers$Multipart$BodyPartParser$$boyerMoore;
        private final Inlet in;
        private final Outlet out;
        private final FlowShape shape;

        public BodyPartParser(String boundary, long maxMemoryBufferSize, int maxHeaderSize, boolean allowEmptyFiles) {
            this.play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize = maxMemoryBufferSize;
            this.play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize = maxHeaderSize;
            this.play$core$parsers$Multipart$BodyPartParser$$allowEmptyFiles = allowEmptyFiles;
            Predef$.MODULE$.require(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(boundary)), this::$init$$$anonfun$1);
            Predef$.MODULE$.require(boundary.charAt(boundary.length() - 1) != ' ', this::$init$$$anonfun$2);
            byte[] array = new byte[boundary.length() + 4];
            array[0] = (byte)13;
            array[1] = (byte)10;
            array[2] = (byte)45;
            array[3] = (byte)45;
            System.arraycopy(boundary.getBytes("US-ASCII"), 0, array, 4, boundary.length());
            this.play$core$parsers$Multipart$BodyPartParser$$needle = array;
            this.play$core$parsers$Multipart$BodyPartParser$$boyerMoore = new BoyerMoore(this.play$core$parsers$Multipart$BodyPartParser$$needle);
            this.in = Inlet$.MODULE$.apply("BodyPartParser.in");
            this.out = Outlet$.MODULE$.apply("BodyPartParser.out");
            this.shape = FlowShape$.MODULE$.of(this.in(), this.out());
        }

        public BodyPartParser(String boundary, long maxMemoryBufferSize, int maxHeaderSize) {
            this(boundary, maxMemoryBufferSize, maxHeaderSize, false);
        }

        public final Multipart$BodyPartParser$Done$ Done() {
            Object object = this.Done$lzy1;
            if (object instanceof Multipart$BodyPartParser$Done$) {
                return (Multipart$BodyPartParser$Done$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Multipart$BodyPartParser$Done$)this.Done$lzyINIT1();
        }

        private Object Done$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.Done$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Multipart$BodyPartParser$Done$ multipart$BodyPartParser$Done$ = null;
                        try {
                            multipart$BodyPartParser$Done$ = new Multipart$BodyPartParser$Done$();
                            object2 = multipart$BodyPartParser$Done$ == null ? LazyVals.NullValue$.MODULE$ : multipart$BodyPartParser$Done$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.Done$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return multipart$BodyPartParser$Done$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public final Multipart$BodyPartParser$ContinueParsing$ ContinueParsing() {
            Object object = this.ContinueParsing$lzy1;
            if (object instanceof Multipart$BodyPartParser$ContinueParsing$) {
                return (Multipart$BodyPartParser$ContinueParsing$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (Multipart$BodyPartParser$ContinueParsing$)this.ContinueParsing$lzyINIT1();
        }

        private Object ContinueParsing$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.ContinueParsing$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        Multipart$BodyPartParser$ContinueParsing$ multipart$BodyPartParser$ContinueParsing$ = null;
                        try {
                            multipart$BodyPartParser$ContinueParsing$ = new Multipart$BodyPartParser$ContinueParsing$(this);
                            object2 = multipart$BodyPartParser$ContinueParsing$ == null ? LazyVals.NullValue$.MODULE$ : multipart$BodyPartParser$ContinueParsing$;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.ContinueParsing$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return multipart$BodyPartParser$ContinueParsing$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        public Inlet<ByteString> in() {
            return this.in;
        }

        public Outlet<Either<MultipartFormData.Part<BoxedUnit>, ByteString>> out() {
            return this.out;
        }

        public FlowShape<ByteString, Either<MultipartFormData.Part<BoxedUnit>, ByteString>> shape() {
            return this.shape;
        }

        public GraphStageLogic createLogic(Attributes attributes) {
            return new InHandler(this){
                private Queue output;
                private Function1 state;
                private boolean terminated;
                private final /* synthetic */ BodyPartParser $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    super($outer.shape());
                    this.output = Queue$.MODULE$.empty();
                    this.state = (Function1 & Serializable)input2 -> this.tryParseInitialBoundary((ByteString)input2);
                    this.terminated = false;
                    this.setHandlers($outer.in(), $outer.out(), this);
                }

                public void onPush() {
                    if (!this.terminated) {
                        this.state.apply(this.grab(this.$outer.in()));
                        if (this.output.nonEmpty()) {
                            this.push(this.$outer.out(), this.dequeue());
                            return;
                        }
                        if (!this.terminated) {
                            this.pull(this.$outer.in());
                            return;
                        }
                        this.completeStage();
                        return;
                    }
                    this.completeStage();
                }

                public void onPull() {
                    if (this.output.nonEmpty()) {
                        this.push(this.$outer.out(), this.dequeue());
                        return;
                    }
                    if (this.isClosed(this.$outer.in())) {
                        if (!this.terminated) {
                            this.push(this.$outer.out(), package$.MODULE$.Left().apply((Object)MultipartFormData$ParseError$.MODULE$.apply("Unexpected end of input")));
                        }
                        this.completeStage();
                        return;
                    }
                    this.pull(this.$outer.in());
                }

                public void onUpstreamFinish() {
                    if (this.isAvailable(this.$outer.out())) {
                        this.onPull();
                        return;
                    }
                }

                public Done handleParsingState(ContinueParsing parse) {
                    StateResult stateResult;
                    while (true) {
                        ContinueParsing c;
                        stateResult = parse.apply();
                        if (this.$outer.Done().equals(stateResult)) {
                            return this.$outer.Done();
                        }
                        if (!(stateResult instanceof ContinueParsing) || ((ContinueParsing)stateResult).play$core$parsers$Multipart$BodyPartParser$ContinueParsing$$$outer() != this.$outer) break;
                        parse = c = (ContinueParsing)stateResult;
                    }
                    throw new MatchError((Object)stateResult);
                }

                public Done handleParsingState(Function0 exec) {
                    return this.handleParsingState(this.$outer.ContinueParsing().apply((Function0<StateResult>)exec));
                }

                public Done tryParseInitialBoundary(ByteString input2) {
                    Done done;
                    try {
                        int ix;
                        done = this.boundary(input2, 0, this.boundary$default$3()) ? (this.crlf(input2, ix = this.boundaryLength()) ? this.handleParsingState(() -> this.tryParseInitialBoundary$$anonfun$1(input2, ix)) : (this.doubleDash(input2, ix) ? this.terminate() : this.parsePreamble(input2, 0))) : this.parsePreamble(input2, 0);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            done = this.continue(input2, 0, (Function2 & Serializable)(newInput, _$15) -> this.tryParseInitialBoundary$$anonfun$2((ByteString)newInput, BoxesRunTime.unboxToInt((Object)_$15)));
                        }
                        throw throwable;
                    }
                    return done;
                }

                public Done parsePreamble(ByteString input3, int offset2) {
                    Done done;
                    try {
                        done = this.rec$1(input3, offset2);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            done = this.continue(input3.takeRight(this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length + 2), 0, (Function2 & Serializable)(input2, offset) -> this.parsePreamble$$anonfun$1((ByteString)input2, BoxesRunTime.unboxToInt((Object)offset)));
                        }
                        throw throwable;
                    }
                    return done;
                }

                public StateResult parseHeader(ByteString input2, int headerStart, int memoryBufferSize) {
                    int n = input2.indexOfSlice((Seq)Multipart$.play$core$parsers$Multipart$$$crlfcrlf, headerStart);
                    if (-1 == n) {
                        if (input2.length() - headerStart >= this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize) {
                            return this.bufferExceeded("Header length exceeded maximum header size of " + this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize);
                        }
                        return this.continue(input2, headerStart, (Function2 & Serializable)(_$16, _$17) -> this.parseHeader$$anonfun$1(memoryBufferSize, (ByteString)_$16, BoxesRunTime.unboxToInt((Object)_$17)));
                    }
                    int headerEnd = n;
                    if (headerEnd - headerStart >= this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize) {
                        return this.bufferExceeded("Header length exceeded maximum header size of " + this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxHeaderSize);
                    }
                    int headerEnd2 = n;
                    String headerString = input2.slice(headerStart, headerEnd2).utf8String();
                    Map headers = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(headerString)).map(Multipart$::play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$_$$anonfun$8).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    int partStart = headerEnd2 + 4;
                    int totalMemoryBufferSize = memoryBufferSize + Multipart$.play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$headersSize$1(headers);
                    Map map = headers;
                    if (map != null) {
                        Option<Tuple4<String, String, Option<String>, String>> option = Multipart$FileInfoMatcher$.MODULE$.unapply((Map<String, String>)map);
                        if (!option.isEmpty()) {
                            Tuple4 tuple4 = (Tuple4)option.get();
                            String partName = (String)tuple4._1();
                            String fileName = (String)tuple4._2();
                            Option contentType = (Option)tuple4._3();
                            String dispositionType = (String)tuple4._4();
                            if (this.$outer.play$core$parsers$Multipart$BodyPartParser$$allowEmptyFiles) {
                                return this.processFilePart$1(partStart, totalMemoryBufferSize, partName, fileName, contentType, dispositionType, input2);
                            }
                            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(fileName.trim()))) {
                                return this.checkEmptyBody(input2, partStart, totalMemoryBufferSize, (Function1 & Serializable)newInput -> this.processFilePart$1(partStart, totalMemoryBufferSize, partName, fileName, contentType, dispositionType, (ByteString)newInput), (Function1 & Serializable)newInput -> this.handleBadPart((ByteString)newInput, partStart, totalMemoryBufferSize, headers));
                            }
                            return this.handleBadPart(input2, partStart, totalMemoryBufferSize, headers);
                        }
                        Option<String> option2 = Multipart$PartInfoMatcher$.MODULE$.unapply((Map<String, String>)map);
                        if (!option2.isEmpty()) {
                            String string;
                            String name = string = (String)option2.get();
                            return this.handleDataPart(input2, partStart, memoryBufferSize + name.length(), name);
                        }
                    }
                    return this.handleBadPart(input2, partStart, totalMemoryBufferSize, headers);
                }

                public StateResult checkEmptyBody(ByteString input2, int partStart, int memoryBufferSize, Function1 nonEmpty, Function1 empty) {
                    StateResult stateResult;
                    try {
                        int currentPartEnd = this.$outer.play$core$parsers$Multipart$BodyPartParser$$boyerMoore.nextIndex(input2, partStart);
                        stateResult = currentPartEnd - partStart == 0 ? (StateResult)empty.apply((Object)input2) : (StateResult)nonEmpty.apply((Object)input2);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            if (partStart <= input2.length() - this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length) {
                                stateResult = (StateResult)nonEmpty.apply((Object)input2);
                            } else {
                                this.state = (Function1 & Serializable)more -> this.handleParsingState(() -> this.checkEmptyBody$$anonfun$1$$anonfun$1(input2, partStart, memoryBufferSize, nonEmpty, empty, more));
                                stateResult = this.done();
                            }
                        }
                        throw throwable;
                    }
                    return stateResult;
                }

                public StateResult handleFilePart(ByteString input2, int partStart, int memoryBufferSize, String partName, String fileName, Option contentType, String dispositionType) {
                    if ((long)memoryBufferSize > this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize) {
                        return this.bufferExceeded("Memory buffer full (" + this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize + ") on part " + partName);
                    }
                    this.emit(MultipartFormData$FilePart$.MODULE$.apply(partName, fileName, (Option<String>)contentType, BoxedUnit.UNIT, -1L, dispositionType, Multipart$::play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$handleFilePart$$anonfun$1));
                    return this.handleFileData(input2, partStart, memoryBufferSize);
                }

                public StateResult handleFileData(ByteString input2, int offset, int memoryBufferSize) {
                    StateResult stateResult;
                    try {
                        int currentPartEnd = this.$outer.play$core$parsers$Multipart$BodyPartParser$$boyerMoore.nextIndex(input2, offset);
                        int needleEnd = currentPartEnd + this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length;
                        if (this.crlf(input2, needleEnd)) {
                            this.emit(input2.slice(offset, currentPartEnd));
                            stateResult = this.$outer.ContinueParsing().apply((Function0<StateResult>)((Function0 & Serializable)() -> this.handleFileData$$anonfun$1(input2, memoryBufferSize, needleEnd)));
                        } else if (this.doubleDash(input2, needleEnd)) {
                            this.emit(input2.slice(offset, currentPartEnd));
                            stateResult = this.terminate();
                        } else {
                            stateResult = this.fail("Unexpected boundary");
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            int emitEnd = input2.length() - this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length - 2;
                            if (emitEnd > offset) {
                                this.emit(input2.slice(offset, emitEnd));
                                stateResult = this.continue(input2.drop(emitEnd), 0, (Function2 & Serializable)(_$19, _$20) -> this.handleFileData$$anonfun$2(memoryBufferSize, (ByteString)_$19, BoxesRunTime.unboxToInt((Object)_$20)));
                            } else {
                                stateResult = this.continue(input2, offset, (Function2 & Serializable)(_$21, _$22) -> this.handleFileData$$anonfun$3(memoryBufferSize, (ByteString)_$21, BoxesRunTime.unboxToInt((Object)_$22)));
                            }
                        }
                        throw throwable;
                    }
                    return stateResult;
                }

                public StateResult handleDataPart(ByteString input2, int partStart, int memoryBufferSize, String partName) {
                    StateResult stateResult;
                    try {
                        int currentPartEnd = this.$outer.play$core$parsers$Multipart$BodyPartParser$$boyerMoore.nextIndex(input2, partStart);
                        int needleEnd = currentPartEnd + this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length;
                        int newMemoryBufferSize = memoryBufferSize + (currentPartEnd - partStart);
                        if ((long)newMemoryBufferSize > this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize) {
                            stateResult = this.bufferExceeded("Memory buffer full on part " + partName);
                        } else if (this.crlf(input2, needleEnd)) {
                            this.emit(MultipartFormData$DataPart$.MODULE$.apply(partName, input2.slice(partStart, currentPartEnd).utf8String()));
                            stateResult = this.$outer.ContinueParsing().apply((Function0<StateResult>)((Function0 & Serializable)() -> this.handleDataPart$$anonfun$1(input2, needleEnd, newMemoryBufferSize)));
                        } else if (this.doubleDash(input2, needleEnd)) {
                            this.emit(MultipartFormData$DataPart$.MODULE$.apply(partName, input2.slice(partStart, currentPartEnd).utf8String()));
                            stateResult = this.terminate();
                        } else {
                            stateResult = this.fail("Unexpected boundary");
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            if ((long)(memoryBufferSize + (input2.length() - partStart - this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length)) > this.$outer.play$core$parsers$Multipart$BodyPartParser$$maxMemoryBufferSize) {
                                this.bufferExceeded("Memory buffer full on part " + partName);
                            }
                            stateResult = this.continue(input2, partStart, (Function2 & Serializable)(_$23, _$24) -> this.handleDataPart$$anonfun$2(memoryBufferSize, partName, (ByteString)_$23, BoxesRunTime.unboxToInt((Object)_$24)));
                        }
                        throw throwable;
                    }
                    return stateResult;
                }

                public StateResult handleBadPart(ByteString input2, int partStart, int memoryBufferSize, Map headers) {
                    StateResult stateResult;
                    try {
                        int currentPartEnd = this.$outer.play$core$parsers$Multipart$BodyPartParser$$boyerMoore.nextIndex(input2, partStart);
                        int needleEnd = currentPartEnd + this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length;
                        if (this.crlf(input2, needleEnd)) {
                            this.emit(MultipartFormData$BadPart$.MODULE$.apply((Map<String, String>)headers));
                            stateResult = this.$outer.ContinueParsing().apply((Function0<StateResult>)((Function0 & Serializable)() -> this.handleBadPart$$anonfun$1(input2, memoryBufferSize, needleEnd)));
                        } else if (this.doubleDash(input2, needleEnd)) {
                            this.emit(MultipartFormData$BadPart$.MODULE$.apply((Map<String, String>)headers));
                            stateResult = this.terminate();
                        } else {
                            stateResult = this.fail("Unexpected boundary");
                        }
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (Multipart$NotEnoughDataException$.MODULE$.equals(throwable2)) {
                            stateResult = this.continue(input2, partStart, (Function2 & Serializable)(_$25, _$26) -> this.handleBadPart$$anonfun$2(memoryBufferSize, headers, (ByteString)_$25, BoxesRunTime.unboxToInt((Object)_$26)));
                        }
                        throw throwable;
                    }
                    return stateResult;
                }

                public void emit(ByteString bytes) {
                    if (bytes.nonEmpty()) {
                        this.output = this.output.enqueue((Object)package$.MODULE$.Right().apply((Object)bytes));
                        return;
                    }
                }

                public void emit(MultipartFormData.Part part) {
                    this.output = this.output.enqueue((Object)package$.MODULE$.Left().apply((Object)part));
                }

                public Either dequeue() {
                    Either head = (Either)this.output.head();
                    this.output = this.output.tail();
                    return head;
                }

                public Done continue(ByteString input2, int offset, Function2 next) {
                    Function1 & Serializable intersect;
                    int n = scala.math.package$.MODULE$.signum(offset - input2.length());
                    switch (n) {
                        case -1: {
                            intersect = (Function1 & Serializable)more -> this.handleParsingState(() -> Multipart$.play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$1$$anonfun$1(input2, offset, next, more));
                            break;
                        }
                        case 0: {
                            intersect = (Function1 & Serializable)more -> this.handleParsingState(() -> Multipart$.play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$2$$anonfun$1(next, more));
                            break;
                        }
                        case 1: {
                            throw new IllegalStateException();
                        }
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                        }
                    }
                    this.state = intersect;
                    return this.done();
                }

                public Done bufferExceeded(String message) {
                    this.emit(MultipartFormData$MaxMemoryBufferExceeded$.MODULE$.apply(message));
                    return this.terminate();
                }

                public Done fail(String message) {
                    this.emit(MultipartFormData$ParseError$.MODULE$.apply(message));
                    return this.terminate();
                }

                public Done terminate() {
                    this.terminated = true;
                    return this.done();
                }

                public Done done() {
                    return this.$outer.Done();
                }

                public int boundaryLength() {
                    return this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length - 2;
                }

                public boolean boundary(ByteString input2, int offset, int ix) {
                    boolean bl;
                    block3: {
                        block2: {
                            while (ix != this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length) {
                                if (Multipart$.MODULE$.play$core$parsers$Multipart$$$byteAt(input2, offset + ix - 2) == this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle[ix]) {
                                    ++ix;
                                    continue;
                                }
                                break block2;
                            }
                            bl = true;
                            break block3;
                        }
                        bl = false;
                    }
                    return bl;
                }

                public int boundary$default$3() {
                    return 2;
                }

                public boolean crlf(ByteString input2, int offset) {
                    return Multipart$.MODULE$.play$core$parsers$Multipart$$$byteChar(input2, offset) == '\r' && Multipart$.MODULE$.play$core$parsers$Multipart$$$byteChar(input2, offset + 1) == '\n';
                }

                public boolean doubleDash(ByteString input2, int offset) {
                    return Multipart$.MODULE$.play$core$parsers$Multipart$$$byteChar(input2, offset) == '-' && Multipart$.MODULE$.play$core$parsers$Multipart$$$byteChar(input2, offset + 1) == '-';
                }

                private final StateResult tryParseInitialBoundary$$anonfun$1(ByteString input$1, int ix$1) {
                    return this.parseHeader(input$1, ix$1 + 2, 0);
                }

                private final /* synthetic */ StateResult tryParseInitialBoundary$$anonfun$2(ByteString newInput, int _$15) {
                    return this.tryParseInitialBoundary(newInput);
                }

                private final StateResult rec$1$$anonfun$1(ByteString input$3, int needleEnd$1) {
                    return this.parseHeader(input$3, needleEnd$1 + 2, 0);
                }

                private final Done rec$1(ByteString input$2, int index) {
                    int needleEnd;
                    while (!this.crlf(input$2, needleEnd = this.$outer.play$core$parsers$Multipart$BodyPartParser$$boyerMoore.nextIndex(input$2, index) + this.$outer.play$core$parsers$Multipart$BodyPartParser$$needle.length)) {
                        if (this.doubleDash(input$2, needleEnd)) {
                            return this.terminate();
                        }
                        index = needleEnd;
                    }
                    return this.handleParsingState(() -> this.rec$1$$anonfun$1(input$2, needleEnd));
                }

                private final /* synthetic */ StateResult parsePreamble$$anonfun$1(ByteString input2, int offset) {
                    return this.parsePreamble(input2, offset);
                }

                private final /* synthetic */ StateResult parseHeader$$anonfun$1(int memoryBufferSize$1, ByteString _$16, int _$17) {
                    return this.parseHeader(_$16, _$17, memoryBufferSize$1);
                }

                private final StateResult processFilePart$1(int partStart$1, int totalMemoryBufferSize$1, String partName$3, String fileName$1, Option contentType$3, String dispositionType$5, ByteString in) {
                    return this.handleFilePart(in, partStart$1, totalMemoryBufferSize$1, partName$3, fileName$1, contentType$3, dispositionType$5);
                }

                private final StateResult checkEmptyBody$$anonfun$1$$anonfun$1(ByteString input$5, int partStart$4, int memoryBufferSize$3, Function1 nonEmpty$2, Function1 empty$2, ByteString more$1) {
                    return this.checkEmptyBody(input$5.$plus$plus(more$1), partStart$4, memoryBufferSize$3, nonEmpty$2, empty$2);
                }

                private final StateResult handleFileData$$anonfun$1(ByteString input$6, int memoryBufferSize$4, int needleEnd$2) {
                    return this.parseHeader(input$6, needleEnd$2 + 2, memoryBufferSize$4);
                }

                private final /* synthetic */ StateResult handleFileData$$anonfun$2(int memoryBufferSize$5, ByteString _$19, int _$20) {
                    return this.handleFileData(_$19, _$20, memoryBufferSize$5);
                }

                private final /* synthetic */ StateResult handleFileData$$anonfun$3(int memoryBufferSize$6, ByteString _$21, int _$22) {
                    return this.handleFileData(_$21, _$22, memoryBufferSize$6);
                }

                private final StateResult handleDataPart$$anonfun$1(ByteString input$7, int needleEnd$3, int newMemoryBufferSize$1) {
                    return this.parseHeader(input$7, needleEnd$3 + 2, newMemoryBufferSize$1);
                }

                private final /* synthetic */ StateResult handleDataPart$$anonfun$2(int memoryBufferSize$7, String partName$4, ByteString _$23, int _$24) {
                    return this.handleDataPart(_$23, _$24, memoryBufferSize$7, partName$4);
                }

                private final StateResult handleBadPart$$anonfun$1(ByteString input$8, int memoryBufferSize$8, int needleEnd$4) {
                    return this.parseHeader(input$8, needleEnd$4 + 2, memoryBufferSize$8);
                }

                private final /* synthetic */ StateResult handleBadPart$$anonfun$2(int memoryBufferSize$9, Map headers$7, ByteString _$25, int _$26) {
                    return this.handleBadPart(_$25, _$26, memoryBufferSize$9, headers$7);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$3(org.apache.pekko.util.ByteString ), tryParseInitialBoundary$$anonfun$1(org.apache.pekko.util.ByteString int ), tryParseInitialBoundary$$anonfun$adapted$1(java.lang.Object java.lang.Object ), parsePreamble$$anonfun$adapted$1(java.lang.Object java.lang.Object ), parseHeader$$anonfun$adapted$1(int java.lang.Object java.lang.Object ), play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$_$$anonfun$8(java.lang.String ), parseHeader$$anonfun$2(int int java.lang.String java.lang.String scala.Option java.lang.String org.apache.pekko.util.ByteString ), parseHeader$$anonfun$3(scala.collection.immutable.Map int int org.apache.pekko.util.ByteString ), checkEmptyBody$$anonfun$1(org.apache.pekko.util.ByteString int int scala.Function1 scala.Function1 org.apache.pekko.util.ByteString ), play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$handleFilePart$$anonfun$1(java.lang.Object ), handleFileData$$anonfun$1(org.apache.pekko.util.ByteString int int ), handleFileData$$anonfun$adapted$1(int java.lang.Object java.lang.Object ), handleFileData$$anonfun$adapted$2(int java.lang.Object java.lang.Object ), handleDataPart$$anonfun$1(org.apache.pekko.util.ByteString int int ), handleDataPart$$anonfun$adapted$1(int java.lang.String java.lang.Object java.lang.Object ), handleBadPart$$anonfun$1(org.apache.pekko.util.ByteString int int ), handleBadPart$$anonfun$adapted$1(int scala.collection.immutable.Map java.lang.Object java.lang.Object ), continue$$anonfun$1(org.apache.pekko.util.ByteString int scala.Function2 org.apache.pekko.util.ByteString ), continue$$anonfun$2(scala.Function2 org.apache.pekko.util.ByteString ), rec$1$$anonfun$1(org.apache.pekko.util.ByteString int ), checkEmptyBody$$anonfun$1$$anonfun$1(org.apache.pekko.util.ByteString int int scala.Function1 scala.Function1 org.apache.pekko.util.ByteString ), play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$1$$anonfun$1(org.apache.pekko.util.ByteString int scala.Function2 org.apache.pekko.util.ByteString ), play$core$parsers$Multipart$BodyPartParser$$anon$7$$_$continue$$anonfun$2$$anonfun$1(scala.Function2 org.apache.pekko.util.ByteString )}, serializedLambda);
                }
            };
        }

        private final Object $init$$$anonfun$1() {
            return "'boundary' parameter of multipart Content-Type must be non-empty";
        }

        private final Object $init$$$anonfun$2() {
            return "'boundary' parameter of multipart Content-Type must not end with a space char";
        }

        public class ContinueParsing
        implements StateResult {
            private final Function0<StateResult> parse;
            private final /* synthetic */ BodyPartParser $outer;

            public ContinueParsing(BodyPartParser $outer, Function0<StateResult> parse) {
                this.parse = parse;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public StateResult apply() {
                return (StateResult)this.parse.apply();
            }

            public final /* synthetic */ BodyPartParser play$core$parsers$Multipart$BodyPartParser$ContinueParsing$$$outer() {
                return this.$outer;
            }
        }

        public interface Done
        extends StateResult {
        }

        public interface StateResult {
        }
    }

    public static class BoyerMoore {
        private final byte[] needle;
        private final int nl1;
        private final int[] charTable;
        private final int[] offsetTable;

        /*
         * WARNING - void declaration
         */
        public BoyerMoore(byte[] needle) {
            void var3_3;
            void var2_2;
            this.needle = needle;
            Predef$.MODULE$.require(needle.length > 0, this::$init$$$anonfun$4);
            this.nl1 = needle.length - 1;
            int[] table = (int[])Array$.MODULE$.fill(256, () -> this.$anonfun$9(needle), ClassTag$.MODULE$.apply(Integer.TYPE));
            this.rec$2(needle, table, 0);
            this.charTable = var2_2;
            int[] table2 = new int[needle.length];
            this.loop1$1(needle, table2, this.nl1, needle.length);
            this.loop2$1(needle, table2, 0);
            this.offsetTable = var3_3;
        }

        public int nextIndex(ByteString haystack, int offset) {
            return this.rec$3(haystack, offset + this.nl1, this.nl1);
        }

        private final Object $init$$$anonfun$4() {
            return "needle must be non-empty";
        }

        private final int $anonfun$9(byte[] needle$1) {
            return needle$1.length;
        }

        private final void rec$2(byte[] needle$2, int[] table$1, int i) {
            while (i < this.nl1) {
                table$1[needle$2[i] & 0xFF] = this.nl1 - i;
                ++i;
            }
        }

        private final boolean isPrefix$1(byte[] needle$3, int i, int j) {
            boolean bl;
            block3: {
                block2: {
                    while (i != needle$3.length) {
                        if (needle$3[i] == needle$3[j]) {
                            int n = i + 1;
                            int n2 = j + 1;
                            i = n;
                            j = n2;
                            continue;
                        }
                        break block2;
                    }
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }

        private final void loop1$1(byte[] needle$4, int[] table$2, int i, int lastPrefixPosition) {
            while (i >= 0) {
                int nextLastPrefixPosition = this.isPrefix$1(needle$4, i + 1, 0) ? i + 1 : lastPrefixPosition;
                table$2[this.nl1 - i] = nextLastPrefixPosition - i + this.nl1;
                int n = i - 1;
                int n2 = nextLastPrefixPosition;
                i = n;
                lastPrefixPosition = n2;
            }
        }

        private final int suffixLength$1(byte[] needle$5, int i, int j, int result) {
            while (i >= 0 && needle$5[i] == needle$5[j]) {
                int n = i - 1;
                int n2 = j - 1;
                int n3 = result + 1;
                i = n;
                j = n2;
                result = n3;
            }
            return result;
        }

        private final void loop2$1(byte[] needle$6, int[] table$3, int i) {
            while (i < this.nl1) {
                int sl = this.suffixLength$1(needle$6, i, this.nl1, 0);
                table$3[sl] = this.nl1 - i + sl;
                ++i;
            }
        }

        private final int rec$3(ByteString haystack$1, int i, int j) {
            while (true) {
                byte by;
                if (this.needle[j] == (by = Multipart$.MODULE$.play$core$parsers$Multipart$$$byteAt(haystack$1, i))) {
                    if (j == 0) {
                        return i;
                    }
                    int n = i - 1;
                    int n2 = j - 1;
                    i = n;
                    j = n2;
                    continue;
                }
                int n = i + scala.math.package$.MODULE$.max(this.offsetTable[this.nl1 - j], this.charTable[by & 0xFF]);
                int n3 = this.nl1;
                i = n;
                j = n3;
            }
        }
    }

    public static class FileInfo
    implements Product,
    Serializable {
        private final String partName;
        private final String fileName;
        private final Option contentType;
        private final String dispositionType;

        public static FileInfo apply(String string, String string2, Option<String> option, String string3) {
            return Multipart$FileInfo$.MODULE$.apply(string, string2, option, string3);
        }

        public static FileInfo fromProduct(Product product) {
            return Multipart$FileInfo$.MODULE$.fromProduct(product);
        }

        public static FileInfo unapply(FileInfo fileInfo) {
            return Multipart$FileInfo$.MODULE$.unapply(fileInfo);
        }

        public static String $lessinit$greater$default$4() {
            return Multipart$FileInfo$.MODULE$.$lessinit$greater$default$4();
        }

        public FileInfo(String partName, String fileName, Option<String> contentType, String dispositionType) {
            this.partName = partName;
            this.fileName = fileName;
            this.contentType = contentType;
            this.dispositionType = dispositionType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FileInfo)) return false;
            FileInfo fileInfo = (FileInfo)object;
            String string = this.partName();
            String string2 = fileInfo.partName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.fileName();
            String string4 = fileInfo.fileName();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            Option<String> option = this.contentType();
            Option<String> option2 = fileInfo.contentType();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            String string5 = this.dispositionType();
            String string6 = fileInfo.dispositionType();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            if (!fileInfo.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FileInfo;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "FileInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "partName";
                }
                case 1: {
                    return "fileName";
                }
                case 2: {
                    return "contentType";
                }
                case 3: {
                    return "dispositionType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String partName() {
            return this.partName;
        }

        public String fileName() {
            return this.fileName;
        }

        public Option<String> contentType() {
            return this.contentType;
        }

        public String dispositionType() {
            return this.dispositionType;
        }

        public FileInfo copy(String partName, String fileName, Option<String> contentType, String dispositionType) {
            return new FileInfo(partName, fileName, contentType, dispositionType);
        }

        public String copy$default$1() {
            return this.partName();
        }

        public String copy$default$2() {
            return this.fileName();
        }

        public Option<String> copy$default$3() {
            return this.contentType();
        }

        public String copy$default$4() {
            return this.dispositionType();
        }

        public String _1() {
            return this.partName();
        }

        public String _2() {
            return this.fileName();
        }

        public Option<String> _3() {
            return this.contentType();
        }

        public String _4() {
            return this.dispositionType();
        }
    }
}

