/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.Function1;

public final class SynchronousMappedStreams {
    public static <A, B> Subscriber<A> contramap(Subscriber<B> subscriber, Function1<A, B> function1) {
        return SynchronousMappedStreams$.MODULE$.contramap(subscriber, function1);
    }

    public static <A, B> Publisher<B> map(Publisher<A> publisher, Function1<A, B> function1) {
        return SynchronousMappedStreams$.MODULE$.map(publisher, function1);
    }

    public static <A1, B1, A2, B2> Processor<A1, B2> transform(Processor<B1, A2> processor, Function1<A1, B1> function1, Function1<A2, B2> function12) {
        return SynchronousMappedStreams$.MODULE$.transform(processor, function1, function12);
    }

    public static class JoinedProcessor<A, B>
    implements Processor<A, B> {
        private final Subscriber<A> subscriber;
        private final Publisher<B> publisher;

        public JoinedProcessor(Subscriber<A> subscriber, Publisher<B> publisher) {
            this.subscriber = subscriber;
            this.publisher = publisher;
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onNext(A t) {
            this.subscriber.onNext(t);
        }

        public void subscribe(Subscriber<? super B> s) {
            this.publisher.subscribe(s);
        }

        public String toString() {
            return "JoinedProcessor(" + this.subscriber + ", " + this.publisher + ")";
        }
    }

    public static class SynchronousContramappedSubscriber<A, B>
    implements Subscriber<A> {
        private final Subscriber<? super B> subscriber;
        private final Function1<A, B> f;

        public SynchronousContramappedSubscriber(Subscriber<? super B> subscriber, Function1<A, B> f) {
            this.subscriber = subscriber;
            this.f = f;
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onSubscribe(Subscription s) {
            this.subscriber.onSubscribe(s);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onNext(A a) {
            this.subscriber.onNext(this.f.apply(a));
        }

        public String toString() {
            return "SynchronousContramappedSubscriber(" + this.subscriber + ")";
        }
    }

    public static class SynchronousMappedPublisher<A, B>
    implements Publisher<B> {
        private final Publisher<A> publisher;
        private final Function1<A, B> f;

        public SynchronousMappedPublisher(Publisher<A> publisher, Function1<A, B> f) {
            this.publisher = publisher;
            this.f = f;
        }

        public void subscribe(Subscriber<? super B> s) {
            this.publisher.subscribe(new SynchronousContramappedSubscriber<A, B>(s, this.f));
        }

        public String toString() {
            return "SynchronousMappedPublisher(" + this.publisher + ")";
        }
    }
}

