/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.util.DefaultJoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import play.Logger;
import play.api.Configuration;
import play.api.Configuration$;
import play.api.Environment;
import play.api.Logger$;
import play.api.LoggerConfigurator;
import play.api.LoggerConfigurator$;
import play.api.Mode;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class LogbackLoggerConfigurator
implements LoggerConfigurator {
    public ILoggerFactory loggerFactory() {
        return LoggerFactory.getILoggerFactory();
    }

    public void init(File rootPath, Mode mode) {
        Object[] objectArray = new Tuple2[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"application.home");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)rootPath.getAbsolutePath());
        Map properties = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Mode mode2 = mode;
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        String resourceName = !(mode2 != null ? !mode2.equals(dev$) : dev$ != null) ? "logback-play-dev.xml" : "logback-play-default.xml";
        Option resourceUrl = Option$.MODULE$.apply((Object)this.getClass().getClassLoader().getResource(resourceName));
        this.configure((Map<String, String>)properties, (Option<URL>)resourceUrl);
    }

    public void configure(Environment env) {
        this.configure(env, Configuration$.MODULE$.empty(), (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public void configure(Environment env, Configuration configuration, Map<String, String> optionalProperties) {
        Option configUrl = LogbackLoggerConfigurator.explicitResourceUrl$1(env).orElse(LogbackLoggerConfigurator::$anonfun$1).orElse(LogbackLoggerConfigurator::$anonfun$2).orElse(() -> LogbackLoggerConfigurator.$anonfun$3(env));
        Map properties = LoggerConfigurator$.MODULE$.generateProperties(env, configuration, optionalProperties);
        Logger$.MODULE$.setApplicationMode(env.mode());
        this.configure((Map<String, String>)properties, (Option<URL>)configUrl);
    }

    public void configure(Map<String, String> properties, Option<URL> config) {
        ILoggerFactory factory;
        ILoggerFactory iLoggerFactory = factory = this.loggerFactory();
        synchronized (iLoggerFactory) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            LoggerContext ctx = (LoggerContext)factory;
            ctx.reset();
            LevelChangePropagator levelChangePropagator = new LevelChangePropagator();
            levelChangePropagator.setContext((Context)ctx);
            levelChangePropagator.setResetJUL(true);
            ctx.addListener((LoggerContextListener)levelChangePropagator);
            SLF4JBridgeHandler.install();
            List frameworkPackages = ctx.getFrameworkPackages();
            frameworkPackages.add(Logger.class.getName());
            frameworkPackages.add(play.api.Logger.class.getName());
            properties.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    ctx.putProperty(k, v);
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            Option<URL> option = config;
            if (option instanceof Some) {
                URL url = (URL)((Some)option).value();
                DefaultJoranConfigurator joranConfigurator = new DefaultJoranConfigurator();
                joranConfigurator.setContext((Context)ctx);
                joranConfigurator.configureByResource(url);
            } else if (None$.MODULE$.equals(option)) {
                System.err.println("Could not detect a logback configuration file, not configuring logback");
            } else {
                throw new MatchError(option);
            }
            StatusPrinter.printIfErrorsOccured((Context)ctx);
        }
    }

    public void shutdown() {
        LoggerContext ctx;
        LoggerContext loggerContext = ctx = (LoggerContext)this.loggerFactory();
        synchronized (loggerContext) {
            ctx.stop();
            SLF4JBridgeHandler.uninstall();
            Logger$.MODULE$.unsetApplicationMode();
        }
    }

    private static final URL explicitResourceUrl$1$$anonfun$1$$anonfun$1(Environment env$3, String r$1) {
        return new File(env$3.getFile("conf"), r$1).toURI().toURL();
    }

    private static final Option explicitResourceUrl$1(Environment env$1) {
        return scala.sys.package$.MODULE$.props().get("logger.resource").map((Function1 & Serializable)r -> (URL)env$1.resource(r).getOrElse(() -> LogbackLoggerConfigurator.explicitResourceUrl$1$$anonfun$1$$anonfun$1(env$1, r)));
    }

    private static final Option explicitFileUrl$1() {
        return scala.sys.package$.MODULE$.props().get("logger.file").map((Function1 & Serializable)_$1 -> new File((String)_$1).toURI().toURL());
    }

    private static final Option explicitUrl$1() {
        return scala.sys.package$.MODULE$.props().get("logger.url").map((Function1 & Serializable)_$2 -> new URI((String)_$2).toURL());
    }

    private static final Option defaultResourceUrl$1(Environment env$4) {
        Mode mode = env$4.mode();
        LazyList testConfigs = Mode.Test$.MODULE$.equals(mode) ? (LazyList)package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"logback-test.xml"})) : package$.MODULE$.LazyList().empty();
        Object[] objectArray = new String[2];
        objectArray[0] = "logback.xml";
        Mode mode2 = env$4.mode();
        Mode.Dev$ dev$ = Mode.Dev$.MODULE$;
        objectArray[1] = !(mode2 != null ? !mode2.equals(dev$) : dev$ != null) ? "logback-play-dev.xml" : "logback-play-default.xml";
        return ((LazyList)testConfigs.$plus$plus((IterableOnce)package$.MODULE$.LazyList().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)))).flatMap((Function1 & Serializable)name -> env$4.resource(name)).headOption();
    }

    private static final Option $anonfun$1() {
        return LogbackLoggerConfigurator.explicitFileUrl$1();
    }

    private static final Option $anonfun$2() {
        return LogbackLoggerConfigurator.explicitUrl$1();
    }

    private static final Option $anonfun$3(Environment env$6) {
        return LogbackLoggerConfigurator.defaultResourceUrl$1(env$6);
    }
}

