/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.gradle.task;

import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.UntrackedTask;
import org.pkl.cli.CliProjectPackager;
import org.pkl.commons.cli.CliTestOptions;
import org.pkl.gradle.task.BasePklTask;

@UntrackedTask(because="Output names are known only after execution")
public abstract class ProjectPackageTask
extends BasePklTask {
    @InputFiles
    public abstract ConfigurableFileCollection getProjectDirectories();

    @Internal
    public abstract DirectoryProperty getOutputPath();

    @Optional
    @OutputDirectory
    public abstract DirectoryProperty getJunitReportsDir();

    @Input
    public abstract Property<Boolean> getOverwrite();

    @Input
    @Optional
    public abstract Property<Boolean> getSkipPublishCheck();

    @Override
    protected void doRunTask() {
        List projectDirectories = this.getProjectDirectories().getFiles().stream().map(it -> Path.of(it.getAbsolutePath(), new String[0])).collect(Collectors.toList());
        if (projectDirectories.isEmpty()) {
            throw new InvalidUserDataException("No project directories specified.");
        }
        new CliProjectPackager(this.getCliBaseOptions(), projectDirectories, new CliTestOptions(this.mapAndGetOrNull(this.getJunitReportsDir(), it -> it.getAsFile().toPath()), ((Boolean)this.getOverwrite().get()).booleanValue()), ((Directory)this.getOutputPath().get()).getAsFile().getAbsolutePath(), ((Boolean)this.getSkipPublishCheck().getOrElse((Object)false)).booleanValue(), (Writer)new PrintWriter(System.out), (Writer)new PrintWriter(System.err)).run();
    }
}

