/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.gradle.task;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.pkl.cli.CliProjectResolver;
import org.pkl.gradle.task.BasePklTask;

public abstract class ProjectResolveTask
extends BasePklTask {
    @Internal
    public abstract ConfigurableFileCollection getProjectDirectories();

    @InputFiles
    public Provider<List<File>> getProjectPklFiles() {
        return this.getProjectDirectories().getElements().map(files -> files.stream().map(it -> it.getAsFile().toPath().resolve("PklProject").toFile()).collect(Collectors.toList()));
    }

    @Override
    protected void doRunTask() {
        List projectDirectories = this.getProjectDirectories().getFiles().stream().map(it -> Path.of(it.getAbsolutePath(), new String[0])).collect(Collectors.toList());
        if (projectDirectories.isEmpty()) {
            throw new InvalidUserDataException("No project directories specified.");
        }
        new CliProjectResolver(this.getCliBaseOptions(), projectDirectories, (Writer)new PrintWriter(System.out), (Writer)new PrintWriter(System.err)).run();
    }
}

