/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.gradle;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.Convention;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.util.GradleVersion;
import org.pkl.cli.CliEvaluatorOptions;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.LateInit;
import org.pkl.gradle.PklExtension;
import org.pkl.gradle.spec.BasePklSpec;
import org.pkl.gradle.spec.CodeGenSpec;
import org.pkl.gradle.spec.EvalSpec;
import org.pkl.gradle.spec.JavaCodeGenSpec;
import org.pkl.gradle.spec.KotlinCodeGenSpec;
import org.pkl.gradle.spec.ModulesSpec;
import org.pkl.gradle.spec.PkldocSpec;
import org.pkl.gradle.spec.ProjectPackageSpec;
import org.pkl.gradle.spec.ProjectResolveSpec;
import org.pkl.gradle.spec.TestSpec;
import org.pkl.gradle.task.BasePklTask;
import org.pkl.gradle.task.CodeGenTask;
import org.pkl.gradle.task.EvalTask;
import org.pkl.gradle.task.JavaCodeGenTask;
import org.pkl.gradle.task.KotlinCodeGenTask;
import org.pkl.gradle.task.ModulesTask;
import org.pkl.gradle.task.PkldocTask;
import org.pkl.gradle.task.ProjectPackageTask;
import org.pkl.gradle.task.ProjectResolveTask;
import org.pkl.gradle.task.TestTask;

public class PklPlugin
implements Plugin<Project> {
    private static final String MIN_GRADLE_VERSION = "8.1";
    @LateInit
    private Project project;

    public void apply(Project project) {
        this.project = project;
        if (GradleVersion.current().compareTo(GradleVersion.version((String)MIN_GRADLE_VERSION)) < 0) {
            throw new GradleException(String.format("Plugin `org.pkl` requires Gradle %s or higher.", MIN_GRADLE_VERSION));
        }
        PklExtension extension = (PklExtension)project.getExtensions().create("pkl", PklExtension.class, new Object[0]);
        this.configureExtension(extension);
    }

    private void configureExtension(PklExtension extension) {
        this.configureEvalTasks(extension.getEvaluators());
        this.configureJavaCodeGenTasks(extension.getJavaCodeGenerators());
        this.configureKotlinCodeGenTasks(extension.getKotlinCodeGenerators());
        this.configurePkldocTasks(extension.getPkldocGenerators());
        this.configureTestTasks(extension.getTests());
        this.configureProjectPackageTasks(extension.getProject().getPackagers());
        this.configureProjectResolveTasks(extension.getProject().getResolvers());
    }

    private void configureProjectPackageTasks(NamedDomainObjectContainer<ProjectPackageSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            spec.getOutputPath().convention(this.project.getLayout().getBuildDirectory().dir("generated/pkl/packages"));
            spec.getOverwrite().convention((Object)false);
            TaskProvider<ProjectPackageTask> packageTask = this.createTask((Class)ProjectPackageTask.class, (BasePklSpec)spec);
            packageTask.configure(task -> {
                task.getProjectDirectories().from(new Object[]{spec.getProjectDirectories()});
                task.getOutputPath().set((Provider)spec.getOutputPath());
                task.getSkipPublishCheck().set(spec.getSkipPublishCheck());
                task.getJunitReportsDir().set((Provider)spec.getJunitReportsDir());
                task.getOverwrite().set(spec.getOverwrite());
            });
            this.project.getPluginManager().withPlugin("base", appliedPlugin -> this.project.getTasks().named("build", it -> it.dependsOn(new Object[]{packageTask})));
        });
    }

    private void configureProjectResolveTasks(NamedDomainObjectContainer<ProjectResolveSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            TaskProvider<ProjectResolveTask> resolveTask = this.createTask((Class)ProjectResolveTask.class, (BasePklSpec)spec);
            resolveTask.configure(task -> task.getProjectDirectories().from(new Object[]{spec.getProjectDirectories()}));
        });
    }

    private void configureEvalTasks(NamedDomainObjectContainer<EvalSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            spec.getOutputFile().convention(this.project.getLayout().getProjectDirectory().file("%{moduleDir}/%{moduleName}.%{outputFormat}"));
            spec.getOutputFormat().convention((Object)"pcf");
            spec.getModuleOutputSeparator().convention((Object)CliEvaluatorOptions.Companion.getDefaults().getModuleOutputSeparator());
            spec.getExpression().convention((Object)CliEvaluatorOptions.Companion.getDefaults().getExpression());
            this.createModulesTask((Class)EvalTask.class, (ModulesSpec)spec).configure(task -> {
                task.getOutputFile().set((Provider)spec.getOutputFile());
                task.getOutputFormat().set(spec.getOutputFormat());
                task.getModuleOutputSeparator().set(spec.getModuleOutputSeparator());
                task.getMultipleFileOutputDir().set((Provider)spec.getMultipleFileOutputDir());
                task.getExpression().set(spec.getExpression());
            });
        });
    }

    private void configureJavaCodeGenTasks(NamedDomainObjectContainer<JavaCodeGenSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            this.configureCodeGenSpec((CodeGenSpec)spec);
            spec.getGenerateGetters().convention((Object)false);
            spec.getGenerateJavadoc().convention((Object)false);
            this.createModulesTask((Class)JavaCodeGenTask.class, (ModulesSpec)spec).configure(task -> {
                this.configureCodeGenTask((CodeGenTask)((Object)((Object)task)), (CodeGenSpec)spec);
                task.getGenerateGetters().set(spec.getGenerateGetters());
                task.getGenerateJavadoc().set(spec.getGenerateJavadoc());
                task.getParamsAnnotation().set(spec.getParamsAnnotation());
                task.getNonNullAnnotation().set(spec.getNonNullAnnotation());
            });
        });
        this.project.afterEvaluate(prj -> specs.all(spec -> {
            this.configureIdeaModule((CodeGenSpec)spec);
            this.configureCodeGenSpecSourceDirectories((CodeGenSpec)spec, "java", s -> Optional.of(s.getJava()));
        }));
    }

    private void configureKotlinCodeGenTasks(NamedDomainObjectContainer<KotlinCodeGenSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            this.configureCodeGenSpec((CodeGenSpec)spec);
            spec.getGenerateKdoc().convention((Object)false);
            this.createModulesTask((Class)KotlinCodeGenTask.class, (ModulesSpec)spec).configure(task -> {
                this.configureCodeGenTask((CodeGenTask)((Object)((Object)task)), (CodeGenSpec)spec);
                task.getGenerateKdoc().set(spec.getGenerateKdoc());
            });
        });
        this.project.afterEvaluate(prj -> specs.all(spec -> {
            this.configureIdeaModule((CodeGenSpec)spec);
            this.configureCodeGenSpecSourceDirectories((CodeGenSpec)spec, "kotlin", this::getKotlinSourceDirectorySet);
        }));
    }

    private void configurePkldocTasks(NamedDomainObjectContainer<PkldocSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            spec.getOutputDir().convention(this.project.getLayout().getBuildDirectory().map(it -> it.dir("pkldoc").dir(spec.getName())));
            this.createModulesTask((Class)PkldocTask.class, (ModulesSpec)spec).configure(task -> task.getOutputDir().set((Provider)spec.getOutputDir()));
        });
    }

    private void configureTestTasks(NamedDomainObjectContainer<TestSpec> specs) {
        specs.all(spec -> {
            this.configureBaseSpec((BasePklSpec)spec);
            spec.getOverwrite().convention((Object)false);
            TaskProvider<TestTask> testTask = this.createModulesTask((Class)TestTask.class, (ModulesSpec)spec);
            testTask.configure(task -> {
                task.getJunitReportsDir().set((Provider)spec.getJunitReportsDir());
                task.getOverwrite().set(spec.getOverwrite());
            });
            this.project.getPluginManager().withPlugin("base", appliedPlugin -> this.project.getTasks().named("check", checkTask -> checkTask.dependsOn(new Object[]{testTask})));
        });
    }

    private void configureBaseSpec(BasePklSpec spec) {
        spec.getAllowedModules().convention(List.of("repl:", "file:", "modulepath:", "https:", "pkl:", "package:", "projectpackage:"));
        spec.getAllowedResources().convention(List.of("env:", "prop:", "file:", "modulepath:", "https:", "package:"));
        spec.getEvalRootDir().convention(this.project.getRootProject().getLayout().getProjectDirectory());
        spec.getModuleCacheDir().set(IoUtils.getDefaultModuleCacheDir().toFile());
        spec.getNoCache().convention((Object)false);
        spec.getTestPort().convention((Object)-1);
        spec.getHttpNoProxy().convention(List.of());
    }

    private void configureCodeGenSpec(CodeGenSpec spec) {
        spec.getOutputDir().convention(this.project.getLayout().getBuildDirectory().map(it -> it.dir("generated").dir("pkl").dir(spec.getName())));
        spec.getSourceSet().convention(this.project.getProviders().provider(() -> {
            SourceSetContainer sourceSets = (SourceSetContainer)this.project.getExtensions().findByType(SourceSetContainer.class);
            if (sourceSets == null) {
                return null;
            }
            return (SourceSet)sourceSets.findByName("main");
        }));
        spec.getIndent().convention((Object)"  ");
        spec.getGenerateSpringBootConfig().convention((Object)false);
        spec.getImplementSerializable().convention((Object)false);
        this.configureCodeGenSpecModulePath(spec);
    }

    private void configureCodeGenSpecModulePath(CodeGenSpec spec) {
        ConfigurableFileCollection modulePath = this.project.files(new Object[0]);
        modulePath.from(new Object[]{this.getResourceSourceDirectoriesExceptSpecOutput(spec)}).from(new Object[]{spec.getSourceSet().map(SourceSet::getCompileClasspath)});
        spec.getModulePath().from(new Object[]{modulePath});
    }

    private Provider<Set<File>> getResourceSourceDirectoriesExceptSpecOutput(CodeGenSpec spec) {
        return spec.getSourceSet().flatMap(sourceSet -> spec.getOutputDir().map(specOutputDir -> sourceSet.getResources().getSourceDirectories().filter(f -> !f.getAbsolutePath().startsWith(specOutputDir.getAsFile().getAbsolutePath())).getFiles()));
    }

    private void configureCodeGenSpecSourceDirectories(CodeGenSpec spec, String languageName, Function<? super SourceSet, ? extends Optional<SourceDirectorySet>> extractSourceDirectorySet) {
        TaskProvider task = this.project.getTasks().named(spec.getName(), CodeGenTask.class);
        SourceSet sourceSet = (SourceSet)spec.getSourceSet().get();
        extractSourceDirectorySet.apply((SourceSet)sourceSet).ifPresentOrElse(dirSet -> dirSet.srcDir((Object)task.flatMap(t -> t.getOutputDir().dir(languageName))), () -> this.project.getLogger().debug("Source directory set for language {} is not available, will not add task {} as its dependency", (Object)languageName, (Object)task.getName()));
        sourceSet.getResources().srcDir((Object)task.flatMap(t -> t.getOutputDir().dir("resources")));
    }

    private void configureIdeaModule(CodeGenSpec spec) {
        this.project.getPluginManager().withPlugin("idea", plugin -> {
            IdeaModule module = ((IdeaModel)this.project.getExtensions().getByType(IdeaModel.class)).getModule();
            File outputDir = ((Directory)spec.getOutputDir().get()).getAsFile();
            module.getGeneratedSourceDirs().add(outputDir);
            if (((SourceSet)spec.getSourceSet().get()).getName().toLowerCase().contains("test")) {
                module.getTestSources().from(new Object[]{this.append(module.getTestSources().getFiles(), outputDir)});
            } else {
                module.setSourceDirs(this.append(module.getSourceDirs(), outputDir));
            }
        });
    }

    private void configureCodeGenTask(CodeGenTask task, CodeGenSpec spec) {
        task.getIndent().set(spec.getIndent());
        task.getOutputDir().set((Provider)spec.getOutputDir());
        task.getGenerateSpringBootConfig().set(spec.getGenerateSpringBootConfig());
        task.getImplementSerializable().set(spec.getImplementSerializable());
        task.getRenames().set(spec.getRenames());
    }

    private <T extends BasePklTask, S extends BasePklSpec> void configureBaseTask(T task, S spec) {
        task.getAllowedModules().set(spec.getAllowedModules());
        task.getAllowedResources().set(spec.getAllowedResources());
        task.getEnvironmentVariables().set(spec.getEnvironmentVariables());
        task.getExternalProperties().set(spec.getExternalProperties());
        task.getModulePath().from(new Object[]{spec.getModulePath()});
        task.getSettingsModule().set(spec.getSettingsModule());
        task.getEvalRootDir().set((Provider)spec.getEvalRootDir());
        task.getNoCache().set(spec.getNoCache());
        task.getModuleCacheDir().set((Provider)spec.getModuleCacheDir());
        task.getEvalTimeout().set(spec.getEvalTimeout());
        task.getTestPort().set(spec.getTestPort());
        task.getHttpProxy().set(spec.getHttpProxy());
        task.getHttpNoProxy().set(spec.getHttpNoProxy());
    }

    private <T extends ModulesTask, S extends ModulesSpec> void configureModulesTask(T task, S spec) {
        this.configureBaseTask(task, spec);
        task.getSourceModules().set(spec.getSourceModules());
        task.getTransitiveModules().from(new Object[]{spec.getTransitiveModules()});
        task.getNoProject().set(spec.getNoProject());
        task.getProjectDir().set((Provider)spec.getProjectDir());
        task.getOmitProjectSettings().set(spec.getOmitProjectSettings());
    }

    private <T extends ModulesTask> TaskProvider<T> createModulesTask(Class<T> taskClass, ModulesSpec spec) {
        return this.project.getTasks().register(spec.getName(), taskClass, task -> this.configureModulesTask(task, spec));
    }

    private <T extends BasePklTask> TaskProvider<T> createTask(Class<T> taskClass, BasePklSpec spec) {
        return this.project.getTasks().register(spec.getName(), taskClass, task -> this.configureBaseTask(task, spec));
    }

    private <T> Set<T> append(Set<? extends T> set1, T element) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(set1.size() + 1);
        result.addAll(set1);
        result.add(element);
        return result;
    }

    private Optional<SourceDirectorySet> getKotlinSourceDirectorySet(SourceSet sourceSet) {
        Object kotlinExtension = sourceSet.getExtensions().findByName("kotlin");
        if (kotlinExtension instanceof SourceDirectorySet) {
            SourceDirectorySet sourceDirSet = (SourceDirectorySet)kotlinExtension;
            return Optional.of(sourceDirSet);
        }
        try {
            Method getConventionMethod = sourceSet.getClass().getMethod("getConvention", new Class[0]);
            Object convention = getConventionMethod.invoke((Object)sourceSet, new Object[0]);
            if (convention instanceof Convention) {
                Convention c = (Convention)convention;
                Object kotlinSourceSet = c.getPlugins().get("kotlin");
                if (kotlinSourceSet == null) {
                    this.project.getLogger().debug("Cannot obtain Kotlin source directory set of source set [{}], it does not have the `kotlin` convention plugin", (Object)sourceSet.getName());
                    return Optional.empty();
                }
                Method getKotlinMethod = kotlinSourceSet.getClass().getMethod("getKotlin", new Class[0]);
                Object kotlinSourceDirectorySet = getKotlinMethod.invoke(kotlinSourceSet, new Object[0]);
                if (kotlinSourceDirectorySet instanceof SourceDirectorySet) {
                    SourceDirectorySet sourceDirSet = (SourceDirectorySet)kotlinSourceDirectorySet;
                    return Optional.of(sourceDirSet);
                }
                this.project.getLogger().debug("Cannot obtain Kotlin source directory set, sourceSets.{}.kotlin is of wrong type", (Object)sourceSet.getName());
            } else {
                this.project.getLogger().debug("Cannot obtain Kotlin source directory set, sourceSets.{}.convention returned unexpected type", (Object)sourceSet.getName());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.project.getLogger().debug("Cannot obtain Kotlin source directory set of source set [{}] via a convention", (Object)sourceSet.getName(), (Object)e);
        }
        return Optional.empty();
    }
}

