/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.pkl.config.java.mapper.ConversionException;
import org.pkl.config.java.mapper.Converter;
import org.pkl.config.java.mapper.ConverterFactory;
import org.pkl.config.java.mapper.Reflection;
import org.pkl.config.java.mapper.ValueMapper;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.DurationUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.util.CodeGeneratorUtils;
import org.pkl.core.util.CollectionUtils;

final class PStringToEnum
implements ConverterFactory {
    PStringToEnum() {
    }

    @Override
    public Optional<Converter<?, ?>> create(PClassInfo<?> sourceType, Type targetType) {
        Class<?> rawTargetType = Reflection.toRawType(targetType);
        if (sourceType != PClassInfo.String || !rawTargetType.isEnum()) {
            return Optional.empty();
        }
        return Optional.of(new ConverterImpl(rawTargetType));
    }

    private static final class ConverterImpl
    implements Converter<String, Enum<?>> {
        private final Class<?> enumType;
        private final Map<String, Enum<?>> enumValuesByName;

        private ConverterImpl(Class<?> enumType) {
            this.enumType = enumType;
            Enum[] values = (Enum[])enumType.getEnumConstants();
            this.enumValuesByName = CollectionUtils.newConcurrentHashMap((int)values.length);
            if (enumType == DataSizeUnit.class) {
                for (Enum value : values) {
                    DataSizeUnit unit = (DataSizeUnit)value;
                    this.enumValuesByName.put(CodeGeneratorUtils.toEnumConstantName((String)unit.getSymbol()), value);
                }
            } else if (enumType == DurationUnit.class) {
                for (Enum value : values) {
                    DurationUnit unit = (DurationUnit)value;
                    this.enumValuesByName.put(CodeGeneratorUtils.toEnumConstantName((String)unit.getSymbol()), value);
                }
            } else {
                for (Enum value : values) {
                    this.enumValuesByName.put(value.name(), value);
                }
            }
        }

        @Override
        public Enum<?> convert(String value, ValueMapper valueMapper) {
            Enum<?> enumValue = this.enumValuesByName.get(value);
            if (enumValue == null && (enumValue = this.enumValuesByName.get(CodeGeneratorUtils.toEnumConstantName((String)value))) != null) {
                this.enumValuesByName.put(value, enumValue);
            }
            if (enumValue != null) {
                return enumValue;
            }
            throw new ConversionException(String.format("Cannot convert String `%s` to Enum value of type `%s`.", value, this.enumType.getTypeName()));
        }
    }
}

