/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.config.java.mapper;

import io.leangen.geantyref.CaptureType;
import io.leangen.geantyref.GenericTypeReflector;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Executable;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.pkl.core.util.Nullable;

public final class Reflection {
    private Reflection() {
    }

    public static @Nullable Class<?> tryLoadClass(String qualifiedName) {
        try {
            return Class.forName(qualifiedName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean isMissingTypeArguments(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type baseType = wildcardType.getLowerBounds().length > 0 ? wildcardType.getLowerBounds()[0] : wildcardType.getUpperBounds()[0];
            return Reflection.isMissingTypeArguments(baseType);
        }
        return GenericTypeReflector.isMissingTypeParameters((Type)type);
    }

    public static Type normalize(Type type) {
        if (type instanceof WildcardType) {
            WildcardType wcType = (WildcardType)type;
            Type[] bounds = wcType.getLowerBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
            bounds = wcType.getUpperBounds();
            if (bounds.length > 0) {
                return bounds[0];
            }
        }
        return Reflection.getExactSupertype(type, Reflection.toRawType(type));
    }

    public static Class<?> toRawType(Type type) {
        return GenericTypeReflector.erase((Type)type);
    }

    public static <T> Class<T> toWrapperType(Class<T> type) {
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        return type;
    }

    public static Type getArrayElementType(Type type) {
        return GenericTypeReflector.getArrayComponentType((Type)type);
    }

    public static Type getExactSupertype(Type type, Class<?> rawSupertype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSuperType((Type)type, rawSupertype));
    }

    public static Type getExactSubtype(Type type, Class<?> rawSubtype) {
        return Reflection.uncapture(GenericTypeReflector.getExactSubType((Type)type, rawSubtype));
    }

    public static Type[] getExactParameterTypes(Executable m, Type declaringType) {
        return (Type[])Arrays.stream(GenericTypeReflector.getExactParameterTypes((Executable)m, (AnnotatedType)GenericTypeReflector.annotate((Type)declaringType))).map(annType -> Reflection.uncapture(annType.getType())).toArray(Type[]::new);
    }

    private static Type uncapture(Type type) {
        if (type instanceof CaptureType) {
            return ((CaptureType)type).getWildcardType();
        }
        return type;
    }
}

