// Generated by delombok at Fri Apr 19 18:23:59 UTC 2024
/*
 * Matomo Java Tracker
 *
 * @link https://github.com/matomo/matomo-java-tracker
 * @license https://github.com/matomo/matomo-java-tracker/blob/master/LICENSE BSD-3 Clause
 */
package org.matomo.java.tracking.spring;

import java.time.Duration;
import org.matomo.java.tracking.TrackerConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Configuration properties for the Matomo Tracker.
 *
 * <p>These properties can be configured in the application.properties file. For example:
 * <pre>
 *   matomo.tracker.api-endpoint=https://your-matomo-domain.example/matomo.php
 *   matomo.tracker.default-site-id=1
 *   matomo.tracker.default-auth-token=1234567890abcdef1234567890abcdef
 *   matomo.tracker.enabled=true
 *   matomo.tracker.connect-timeout=10s
 *   matomo.tracker.socket-timeout=30s
 *   matomo.tracker.proxy-host=proxy.example.com
 *   matomo.tracker.proxy-port=8080
 *   matomo.tracker.proxy-username=proxyuser
 *   matomo.tracker.proxy-password=proxypassword
 *   matomo.tracker.user-agent=MatomoJavaClient
 *   matomo.tracker.log-failed-tracking=true
 *   matomo.tracker.disable-ssl-cert-validation=true
 *   matomo.tracker.disable-ssl-host-validation=true
 *   matomo.tracker.thread-pool-size=2
 * </pre>
 *
 * @see MatomoTrackerAutoConfiguration
 * @see TrackerConfiguration
 */
@ConfigurationProperties(prefix = "matomo.tracker")
public class MatomoTrackerProperties {
  /**
   * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
   */
  private String apiEndpoint;
  /**
   * The default ID of the website that will be used if not specified explicitly.
   */
  private Integer defaultSiteId;
  /**
   * The authorization token (parameter token_auth) to use if not specified explicitly.
   */
  private String defaultAuthToken;
  /**
   * Allows to stop the tracker to send requests to the Matomo endpoint.
   */
  private Boolean enabled = true;
  /**
   * The timeout until a connection is established.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null` value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 10 seconds</p>
   */
  private Duration connectTimeout = Duration.ofSeconds(5L);
  /**
   * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
   * period inactivity between two consecutive data packets.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 30 seconds</p>
   */
  private Duration socketTimeout = Duration.ofSeconds(5L);
  /**
   * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
   */
  private String proxyHost;
  /**
   * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
   */
  private Integer proxyPort;
  /**
   * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
   * password must also be set.
   */
  private String proxyUsername;
  /**
   * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
   */
  private String proxyPassword;
  /**
   * A custom user agent to be set. Defaults to "MatomoJavaClient"
   */
  private String userAgent = "MatomoJavaClient";
  /**
   * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
   * false.
   */
  private Boolean logFailedTracking;
  /**
   * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
   * Do not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   * @see #disableSslHostVerification
   */
  private Boolean disableSslCertValidation;
  /**
   * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
   * not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   *
   * @see #disableSslCertValidation
   */
  private Boolean disableSslHostVerification;
  /**
   * The thread pool size for the async sender. Defaults to 2.
   *
   * <p>Attention: If you use this library in a web application, make sure that this thread pool
   * does not exceed the thread pool of the web application. Otherwise, you might run into
   * problems.
   */
  private Integer threadPoolSize = 2;

  /**
   * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
   */
  @java.lang.SuppressWarnings("all")
  public String getApiEndpoint() {
    return this.apiEndpoint;
  }

  /**
   * The default ID of the website that will be used if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  public Integer getDefaultSiteId() {
    return this.defaultSiteId;
  }

  /**
   * The authorization token (parameter token_auth) to use if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  public String getDefaultAuthToken() {
    return this.defaultAuthToken;
  }

  /**
   * Allows to stop the tracker to send requests to the Matomo endpoint.
   */
  @java.lang.SuppressWarnings("all")
  public Boolean getEnabled() {
    return this.enabled;
  }

  /**
   * The timeout until a connection is established.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null` value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 10 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  public Duration getConnectTimeout() {
    return this.connectTimeout;
  }

  /**
   * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
   * period inactivity between two consecutive data packets.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 30 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  public Duration getSocketTimeout() {
    return this.socketTimeout;
  }

  /**
   * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
   */
  @java.lang.SuppressWarnings("all")
  public String getProxyHost() {
    return this.proxyHost;
  }

  /**
   * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
   */
  @java.lang.SuppressWarnings("all")
  public Integer getProxyPort() {
    return this.proxyPort;
  }

  /**
   * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
   * password must also be set.
   */
  @java.lang.SuppressWarnings("all")
  public String getProxyUsername() {
    return this.proxyUsername;
  }

  /**
   * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
   */
  @java.lang.SuppressWarnings("all")
  public String getProxyPassword() {
    return this.proxyPassword;
  }

  /**
   * A custom user agent to be set. Defaults to "MatomoJavaClient"
   */
  @java.lang.SuppressWarnings("all")
  public String getUserAgent() {
    return this.userAgent;
  }

  /**
   * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
   * false.
   */
  @java.lang.SuppressWarnings("all")
  public Boolean getLogFailedTracking() {
    return this.logFailedTracking;
  }

  /**
   * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
   * Do not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   * @see #disableSslHostVerification
   */
  @java.lang.SuppressWarnings("all")
  public Boolean getDisableSslCertValidation() {
    return this.disableSslCertValidation;
  }

  /**
   * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
   * not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   *
   * @see #disableSslCertValidation
   */
  @java.lang.SuppressWarnings("all")
  public Boolean getDisableSslHostVerification() {
    return this.disableSslHostVerification;
  }

  /**
   * The thread pool size for the async sender. Defaults to 2.
   *
   * <p>Attention: If you use this library in a web application, make sure that this thread pool
   * does not exceed the thread pool of the web application. Otherwise, you might run into
   * problems.
   */
  @java.lang.SuppressWarnings("all")
  public Integer getThreadPoolSize() {
    return this.threadPoolSize;
  }

  /**
   * The Matomo Tracking HTTP API endpoint, for example https://your-matomo-domain.example/matomo.php
   */
  @java.lang.SuppressWarnings("all")
  public void setApiEndpoint(final String apiEndpoint) {
    this.apiEndpoint = apiEndpoint;
  }

  /**
   * The default ID of the website that will be used if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  public void setDefaultSiteId(final Integer defaultSiteId) {
    this.defaultSiteId = defaultSiteId;
  }

  /**
   * The authorization token (parameter token_auth) to use if not specified explicitly.
   */
  @java.lang.SuppressWarnings("all")
  public void setDefaultAuthToken(final String defaultAuthToken) {
    this.defaultAuthToken = defaultAuthToken;
  }

  /**
   * Allows to stop the tracker to send requests to the Matomo endpoint.
   */
  @java.lang.SuppressWarnings("all")
  public void setEnabled(final Boolean enabled) {
    this.enabled = enabled;
  }

  /**
   * The timeout until a connection is established.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null` value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 10 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  public void setConnectTimeout(final Duration connectTimeout) {
    this.connectTimeout = connectTimeout;
  }

  /**
   * The socket timeout ({@code SO_TIMEOUT}), which is the timeout for waiting for data or, put differently, a maximum
   * period inactivity between two consecutive data packets.
   *
   * <p>A timeout value of zero is interpreted as an infinite timeout.
   * A `null value is interpreted as undefined (system default if applicable).</p>
   *
   * <p>Default: 30 seconds</p>
   */
  @java.lang.SuppressWarnings("all")
  public void setSocketTimeout(final Duration socketTimeout) {
    this.socketTimeout = socketTimeout;
  }

  /**
   * The hostname or IP address of an optional HTTP proxy. {@code proxyPort} must be configured as well
   */
  @java.lang.SuppressWarnings("all")
  public void setProxyHost(final String proxyHost) {
    this.proxyHost = proxyHost;
  }

  /**
   * The port of an HTTP proxy. {@code proxyHost} must be configured as well.
   */
  @java.lang.SuppressWarnings("all")
  public void setProxyPort(final Integer proxyPort) {
    this.proxyPort = proxyPort;
  }

  /**
   * If the HTTP proxy requires a username for basic authentication, it can be configured here. Proxy host, port and
   * password must also be set.
   */
  @java.lang.SuppressWarnings("all")
  public void setProxyUsername(final String proxyUsername) {
    this.proxyUsername = proxyUsername;
  }

  /**
   * The corresponding password for the basic auth proxy user. The proxy host, port and username must be set as well.
   */
  @java.lang.SuppressWarnings("all")
  public void setProxyPassword(final String proxyPassword) {
    this.proxyPassword = proxyPassword;
  }

  /**
   * A custom user agent to be set. Defaults to "MatomoJavaClient"
   */
  @java.lang.SuppressWarnings("all")
  public void setUserAgent(final String userAgent) {
    this.userAgent = userAgent;
  }

  /**
   * Logs if the Matomo Tracking API endpoint responds with an erroneous HTTP code. Defaults to
   * false.
   */
  @java.lang.SuppressWarnings("all")
  public void setLogFailedTracking(final Boolean logFailedTracking) {
    this.logFailedTracking = logFailedTracking;
  }

  /**
   * Disables SSL certificate validation. This is useful for testing with self-signed certificates.
   * Do not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   * @see #disableSslHostVerification
   */
  @java.lang.SuppressWarnings("all")
  public void setDisableSslCertValidation(final Boolean disableSslCertValidation) {
    this.disableSslCertValidation = disableSslCertValidation;
  }

  /**
   * Disables SSL host verification. This is useful for testing with self-signed certificates. Do
   * not use in production environments. Defaults to false.
   *
   * <p>Attention: This slows down performance
   *
   * @see #disableSslCertValidation
   */
  @java.lang.SuppressWarnings("all")
  public void setDisableSslHostVerification(final Boolean disableSslHostVerification) {
    this.disableSslHostVerification = disableSslHostVerification;
  }

  /**
   * The thread pool size for the async sender. Defaults to 2.
   *
   * <p>Attention: If you use this library in a web application, make sure that this thread pool
   * does not exceed the thread pool of the web application. Otherwise, you might run into
   * problems.
   */
  @java.lang.SuppressWarnings("all")
  public void setThreadPoolSize(final Integer threadPoolSize) {
    this.threadPoolSize = threadPoolSize;
  }
}
