/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.testng;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.pitest.functional.FCollection;
import org.pitest.reflection.IsAnnotatedWith;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitExecutionListener;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.testng.TestNGTestUnit;
import org.testng.annotations.Test;

public class TestNGTestUnitFinder
implements TestUnitFinder {
    private final TestGroupConfig config;
    private final Collection<String> includedTestMethods;

    public TestNGTestUnitFinder(TestGroupConfig config, Collection<String> includedTestMethods) {
        this.config = config;
        this.includedTestMethods = includedTestMethods;
    }

    public List<TestUnit> findTestUnits(Class<?> clazz, TestUnitExecutionListener unused) {
        if (!this.isAbstract(clazz) && (this.hasClassAnnotation(clazz) || this.hasMethodAnnotation(clazz))) {
            return Collections.singletonList(new TestNGTestUnit(clazz, this.config, this.includedTestMethods));
        }
        return Collections.emptyList();
    }

    private boolean hasClassAnnotation(Class<?> clazz) {
        return clazz.getAnnotation(Test.class) != null;
    }

    private boolean hasMethodAnnotation(Class<?> clazz) {
        return FCollection.contains((Iterable)Reflection.allMethods(clazz), (Predicate)IsAnnotatedWith.instance(Test.class));
    }

    private boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }
}

