/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.report.html.MutationGrouping;

public class MutationResultList
implements Iterable<MutationResult> {
    private final List<MutationResult> impl = new ArrayList<MutationResult>();

    public MutationResultList(Collection<MutationResult> results) {
        this.impl.addAll(results);
    }

    public List<MutationGrouping> groupMutationsByLine() {
        this.sortMutationsIntoLineOrder();
        ArrayList<MutationGrouping> groups = new ArrayList<MutationGrouping>();
        ArrayList<Object> sublist = new ArrayList<MutationResult>();
        int lastLineNumber = -1;
        for (MutationResult each : this.impl) {
            if (lastLineNumber != each.getDetails().getLineNumber() && !sublist.isEmpty()) {
                groups.add(new MutationGrouping(lastLineNumber, "Line " + lastLineNumber, sublist));
                sublist = new ArrayList();
            }
            sublist.add(each);
            lastLineNumber = each.getDetails().getLineNumber();
        }
        if (!sublist.isEmpty()) {
            groups.add(new MutationGrouping(lastLineNumber, "Line " + lastLineNumber, sublist));
        }
        return groups;
    }

    private void sortMutationsIntoLineOrder() {
        this.impl.sort(Comparator.comparingInt(o -> o.getDetails().getLineNumber()));
    }

    @Override
    public Iterator<MutationResult> iterator() {
        return this.impl.iterator();
    }

    public List<MutationResult> list() {
        return this.impl;
    }
}

