/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.report.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pitest.mutationtest.report.html.MutationTestSummaryData;
import org.pitest.mutationtest.report.html.MutationTestSummaryDataFileNameComparator;
import org.pitest.mutationtest.report.html.MutationTotals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageSummaryData
implements Comparable<PackageSummaryData> {
    private final String packageName;
    private final Map<String, MutationTestSummaryData> fileNameToSummaryData = new HashMap<String, MutationTestSummaryData>();

    public PackageSummaryData(String packageName) {
        this.packageName = packageName;
    }

    public void addSummaryData(MutationTestSummaryData data) {
        MutationTestSummaryData existing = this.fileNameToSummaryData.get(data.getFileName());
        if (existing == null) {
            this.fileNameToSummaryData.put(data.getFileName(), data);
        } else {
            existing.add(data);
        }
    }

    public MutationTestSummaryData getForSourceFile(String filename) {
        return this.fileNameToSummaryData.get(filename);
    }

    public MutationTotals getTotals() {
        MutationTotals mt = new MutationTotals();
        for (MutationTestSummaryData each : this.fileNameToSummaryData.values()) {
            mt.add(each.getTotals());
        }
        return mt;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageDirectory() {
        return this.packageName;
    }

    public List<MutationTestSummaryData> getSummaryData() {
        ArrayList<MutationTestSummaryData> values = new ArrayList<MutationTestSummaryData>(this.fileNameToSummaryData.values());
        Collections.sort(values, new MutationTestSummaryDataFileNameComparator());
        return values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageSummaryData other = (PackageSummaryData)obj;
        return !(this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName));
    }

    @Override
    public int compareTo(PackageSummaryData arg0) {
        return this.packageName.compareTo(arg0.packageName);
    }
}

