/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classpath.CodeSource;
import org.pitest.functional.FCollection;
import org.pitest.help.Help;
import org.pitest.help.PitHelpError;
import org.pitest.mutationtest.verify.BuildVerifier;

public class DefaultBuildVerifier
implements BuildVerifier {
    @Override
    public void verify(CodeSource code) {
        List codeClasses = FCollection.filter(code.getCode(), DefaultBuildVerifier.isNotSynthetic());
        if (this.hasMutableCode(codeClasses)) {
            this.checkAtLeastOneClassHasLineNumbers(codeClasses);
            this.checkAtLeastOneClassHasSourceFile(codeClasses);
        }
    }

    private boolean hasMutableCode(Collection<ClassInfo> codeClasses) {
        return !codeClasses.isEmpty() && this.hasAtLeastOneClass(codeClasses);
    }

    private boolean hasAtLeastOneClass(Collection<ClassInfo> codeClasses) {
        return FCollection.contains(codeClasses, DefaultBuildVerifier.aConcreteClass());
    }

    private void checkAtLeastOneClassHasLineNumbers(Collection<ClassInfo> codeClasses) {
        if (!FCollection.contains(codeClasses, DefaultBuildVerifier.aClassWithLineNumbers())) {
            throw new PitHelpError(Help.NO_LINE_NUMBERS, new Object[0]);
        }
    }

    private void checkAtLeastOneClassHasSourceFile(List<ClassInfo> codeClasses) {
        if (!FCollection.contains(codeClasses, a -> a.getSourceFileName() != null)) {
            throw new PitHelpError(Help.NO_SOURCE_FILE, new Object[]{codeClasses.get(0).getName().asJavaName()});
        }
    }

    private static Predicate<ClassInfo> aConcreteClass() {
        return a -> !a.isInterface();
    }

    private static Predicate<ClassInfo> aClassWithLineNumbers() {
        return a -> a.getNumberOfCodeLines() != 0;
    }

    private static Predicate<ClassInfo> isNotSynthetic() {
        return a -> !a.isSynthetic();
    }
}

