/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.equivalent;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.bytecode.analysis.MethodMatchers;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.gregor.mutators.returns.BooleanTrueReturnValsMutator;
import org.pitest.sequence.Context;
import org.pitest.sequence.QueryParams;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceMatcher;
import org.pitest.sequence.SequenceQuery;
import org.pitest.sequence.Slot;
import org.pitest.sequence.SlotRead;

class HardCodedTrueEquivalentFilter
implements MutationInterceptor {
    private static final Slot<AbstractInsnNode> MUTATED_INSTRUCTION = Slot.create(AbstractInsnNode.class);
    static final SequenceQuery<AbstractInsnNode> BOXED_TRUE = QueryStart.match(InstructionMatchers.opCode(4)).then(InstructionMatchers.methodCallNamed("valueOf"));
    static final SequenceQuery<AbstractInsnNode> CONSTANT_TRUE = QueryStart.match(InstructionMatchers.getStatic("java/lang/Boolean", "TRUE"));
    static final SequenceMatcher<AbstractInsnNode> EQUIVALENT_TRUE = QueryStart.any(AbstractInsnNode.class).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).then(BOXED_TRUE.or(CONSTANT_TRUE)).then(InstructionMatchers.isInstruction((SlotRead<AbstractInsnNode>)MUTATED_INSTRUCTION.read())).zeroOrMore(QueryStart.match(InstructionMatchers.anyInstruction())).compile(QueryParams.params(AbstractInsnNode.class).withIgnores(InstructionMatchers.notAnInstruction()));
    private static final Set<String> MUTATOR_IDS = new HashSet<String>();
    private ClassTree currentClass;

    HardCodedTrueEquivalentFilter() {
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return FCollection.filter(mutations, (Predicate)Prelude.not(this.isEquivalent(m)));
    }

    private Predicate<MutationDetails> isEquivalent(Mutater m) {
        return new Predicate<MutationDetails>(){

            @Override
            public boolean test(MutationDetails a) {
                MethodTree method;
                if (!MUTATOR_IDS.contains(a.getMutator())) {
                    return false;
                }
                int instruction = a.getInstructionIndex();
                return this.primitiveTrue(instruction, method = HardCodedTrueEquivalentFilter.this.currentClass.methods().stream().filter(MethodMatchers.forLocation(a.getId().getLocation())).findFirst().get()) || this.boxedTrue(instruction, method);
            }

            private boolean primitiveTrue(int instruction, MethodTree method) {
                return method.realInstructionBefore(instruction).getOpcode() == 4;
            }

            private boolean boxedTrue(int instruction, MethodTree method) {
                Context context = Context.start(method.instructions(), (boolean)false);
                context.store(MUTATED_INSTRUCTION.write(), (Object)method.instruction(instruction));
                return EQUIVALENT_TRUE.matches(method.instructions(), context);
            }
        };
    }

    @Override
    public void end() {
        this.currentClass = null;
    }

    static {
        MUTATOR_IDS.add(BooleanTrueReturnValsMutator.TRUE_RETURNS.getGloballyUniqueId());
    }
}

