/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.RecordComponentNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class RecordFilter
implements MutationInterceptor {
    private boolean isRecord;
    private ClassTree currentClass;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.isRecord = "java/lang/Record".equals(clazz.rawNode().superName);
        this.currentClass = clazz;
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isRecord) {
            return mutations.stream().filter(this.makeMethodFilter(this.currentClass)).collect(Collectors.toList());
        }
        return mutations;
    }

    private Predicate<MutationDetails> makeMethodFilter(ClassTree currentClass) {
        Set accessorNames = currentClass.recordComponents().stream().map(this::toName).collect(Collectors.toSet());
        return m -> !accessorNames.contains(m.getMethod().name()) && !this.isStandardMethod(accessorNames.size(), (MutationDetails)m);
    }

    private boolean isStandardMethod(int numberOfComponents, MutationDetails m) {
        return this.isRecordInit(m, numberOfComponents) || this.isRecordEquals(m) || this.isRecordHashCode(m) || this.isRecordToString(m);
    }

    private boolean isRecordInit(MutationDetails m, int numberOfComponents) {
        int airty = Type.getArgumentTypes(m.getId().getLocation().getMethodDesc()).length;
        return m.getMethod().name().equals("<init>") && airty == numberOfComponents;
    }

    private boolean isRecordEquals(MutationDetails m) {
        return m.getId().getLocation().getMethodDesc().equals("(Ljava/lang/Object;)Z") && m.getMethod().name().equals("equals") && this.hasDynamicObjectMethodsCall(m);
    }

    private boolean isRecordHashCode(MutationDetails m) {
        return m.getId().getLocation().getMethodDesc().equals("()I") && m.getMethod().name().equals("hashCode") && this.hasDynamicObjectMethodsCall(m);
    }

    private boolean isRecordToString(MutationDetails m) {
        return m.getId().getLocation().getMethodDesc().equals("()Ljava/lang/String;") && m.getMethod().name().equals("toString") && this.hasDynamicObjectMethodsCall(m);
    }

    private boolean hasDynamicObjectMethodsCall(MutationDetails mutation) {
        Optional<MethodTree> method = this.currentClass.method(mutation.getId().getLocation());
        return method.filter(m -> m.instructions().stream().anyMatch(this::isInvokeDynamicCallToObjectMethods)).isPresent();
    }

    private boolean isInvokeDynamicCallToObjectMethods(AbstractInsnNode node) {
        if (node instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode call = (InvokeDynamicInsnNode)node;
            return call.bsm.getOwner().equals("java/lang/runtime/ObjectMethods") && call.bsm.getName().equals("bootstrap");
        }
        return false;
    }

    private String toName(RecordComponentNode recordComponentNode) {
        return recordComponentNode.name;
    }

    @Override
    public void end() {
        this.currentClass = null;
    }
}

