/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class EnumConstructorFilter
implements MutationInterceptor {
    private boolean isEnum;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.isEnum = clazz.rawNode().superName.equals("java/lang/Enum");
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(this.isInEnumConstructor().negate()).collect(Collectors.toList());
    }

    private Predicate<MutationDetails> isInEnumConstructor() {
        return m -> this.isEnum && m.getMethod().name().equals("<init>");
    }

    @Override
    public void end() {
    }
}

