/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.MethodNode;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;

public class MethodTree {
    private final ClassName owner;
    private final MethodNode rawNode;
    private List<AbstractInsnNode> lazyInstructions;

    public MethodTree(ClassName owner, MethodNode rawNode) {
        this.owner = owner;
        this.rawNode = rawNode;
    }

    public MethodNode rawNode() {
        return this.rawNode;
    }

    public Location asLocation() {
        return Location.location((ClassName)this.owner, (MethodName)MethodName.fromString((String)this.rawNode.name), (String)this.rawNode.desc);
    }

    public AbstractInsnNode realInstructionBefore(int index) {
        AbstractInsnNode candidate = this.instructions().get(index - 1);
        if (candidate.getOpcode() == -1) {
            return this.realInstructionBefore(index - 1);
        }
        return candidate;
    }

    public AbstractInsnNode instruction(int index) {
        return this.instructions().get(index);
    }

    public List<AbstractInsnNode> instructions() {
        if (this.lazyInstructions != null) {
            return this.lazyInstructions;
        }
        return this.createInstructionList();
    }

    public boolean isSynthetic() {
        return (this.rawNode.access & 0x1000) != 0;
    }

    public boolean isPrivate() {
        return (this.rawNode.access & 2) != 0;
    }

    public boolean returns(ClassName clazz) {
        return this.rawNode.desc.endsWith("L" + clazz.asInternalName() + ";");
    }

    public List<AnnotationNode> annotations() {
        ArrayList<AnnotationNode> annotaions = new ArrayList<AnnotationNode>();
        if (this.rawNode.invisibleAnnotations != null) {
            annotaions.addAll(this.rawNode.invisibleAnnotations);
        }
        if (this.rawNode.visibleAnnotations != null) {
            annotaions.addAll(this.rawNode.visibleAnnotations);
        }
        return annotaions;
    }

    private List<AbstractInsnNode> createInstructionList() {
        ArrayList<AbstractInsnNode> list = new ArrayList<AbstractInsnNode>();
        for (AbstractInsnNode abstractInsnNode : this.rawNode.instructions) {
            list.add(abstractInsnNode);
        }
        this.lazyInstructions = list;
        return this.lazyInstructions;
    }
}

