/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.Collection;
import java.util.List;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.CachingByteArraySource;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationSource {
    private final MutationConfig mutationConfig;
    private final TestPrioritiser testPrioritiser;
    private final ClassByteArraySource source;
    private final MutationInterceptor interceptor;

    public MutationSource(MutationConfig mutationConfig, TestPrioritiser testPrioritiser, ClassByteArraySource source, MutationInterceptor interceptor) {
        this.mutationConfig = mutationConfig;
        this.testPrioritiser = testPrioritiser;
        this.source = new CachingByteArraySource(source, 200);
        this.interceptor = interceptor;
    }

    public Collection<MutationDetails> createMutations(ClassName clazz) {
        Mutater m = this.mutationConfig.createMutator(this.source);
        List availableMutations = m.findMutations(clazz);
        if (availableMutations.isEmpty()) {
            return availableMutations;
        }
        ClassTree tree = ClassTree.fromBytes((byte[])this.source.getBytes(clazz.asJavaName()).get());
        this.interceptor.begin(tree);
        Collection<MutationDetails> updatedMutations = this.interceptor.intercept(availableMutations, m);
        this.interceptor.end();
        this.assignTestsToMutations(updatedMutations);
        return updatedMutations;
    }

    private void assignTestsToMutations(Collection<MutationDetails> availableMutations) {
        for (MutationDetails mutation : availableMutations) {
            List<TestInfo> testDetails = this.testPrioritiser.assignTests(mutation);
            mutation.addTestsInOrder(testDetails);
        }
    }
}

