/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.pitest.classpath.CodeSourceFactory;
import org.pitest.coverage.CoverageExporterFactory;
import org.pitest.coverage.TestStatListenerFactory;
import org.pitest.mutationtest.HistoryFactory;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.MutationResultInterceptor;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.build.CoverageTransformerFactory;
import org.pitest.mutationtest.build.MutationGrouperFactory;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.mutationtest.build.TestFilterFactory;
import org.pitest.mutationtest.build.TestPrioritiserFactory;
import org.pitest.mutationtest.config.ConfigurationUpdater;
import org.pitest.mutationtest.config.Services;
import org.pitest.mutationtest.config.ServicesFromClassLoader;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutatorInfo;
import org.pitest.mutationtest.environment.EnvironmentResetPlugin;
import org.pitest.mutationtest.environment.TransformationPlugin;
import org.pitest.mutationtest.verify.BuildVerifierFactory;
import org.pitest.plugin.ClientClasspathPlugin;
import org.pitest.plugin.ProvidesFeature;
import org.pitest.plugin.ToolClasspathPlugin;
import org.pitest.testapi.TestPluginFactory;
import org.pitest.util.IsolationUtils;

public class PluginServices {
    private final Services loader;

    public PluginServices(Services loader) {
        this.loader = loader;
    }

    public static PluginServices makeForLoader(ClassLoader loader) {
        return new PluginServices(new ServicesFromClassLoader(loader));
    }

    public static PluginServices makeForContextLoader() {
        return PluginServices.makeForLoader(IsolationUtils.getContextClassLoader());
    }

    public Collection<? extends ToolClasspathPlugin> findToolClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findListeners());
        l.addAll(this.findGroupers());
        l.addAll(this.findTestPrioritisers());
        l.addAll(this.findInterceptors());
        l.addAll(this.findConfigurationUpdaters());
        l.addAll(this.findMutationResultInterceptor());
        l.addAll(this.findCoverageTransformers());
        l.addAll(this.findVerifiers());
        l.addAll(this.findCodeSources());
        l.addAll(this.findHistory());
        l.addAll(this.findCoverageExport());
        l.addAll(this.findStandAloneMutatorInfos());
        l.addAll(this.findTestStatListeners());
        l.addAll(this.findTestFilters());
        return l;
    }

    public List<? extends ClientClasspathPlugin> findClientClasspathPlugins() {
        ArrayList<Object> l = new ArrayList<Object>();
        l.addAll(this.findMutationEngines());
        l.addAll(this.findMutationOperators());
        l.addAll(this.findTestFrameworkPlugins());
        l.addAll(this.nullPlugins());
        l.addAll(this.load(TransformationPlugin.class));
        l.addAll(this.load(EnvironmentResetPlugin.class));
        return l;
    }

    public Collection<? extends ConfigurationUpdater> findConfigurationUpdaters() {
        return this.load(ConfigurationUpdater.class);
    }

    public Collection<? extends MethodMutatorFactory> findMutationOperators() {
        return this.load(MethodMutatorFactory.class);
    }

    Collection<? extends TestPluginFactory> findTestFrameworkPlugins() {
        return this.load(TestPluginFactory.class);
    }

    Collection<? extends MutationGrouperFactory> findGroupers() {
        return this.load(MutationGrouperFactory.class);
    }

    Collection<? extends MutationResultListenerFactory> findListeners() {
        return this.load(MutationResultListenerFactory.class);
    }

    Collection<? extends MutationEngineFactory> findMutationEngines() {
        return this.load(MutationEngineFactory.class);
    }

    Collection<? extends TestPrioritiserFactory> findTestPrioritisers() {
        return this.load(TestPrioritiserFactory.class);
    }

    private Collection<ClientClasspathPlugin> nullPlugins() {
        return this.load(ClientClasspathPlugin.class);
    }

    public Collection<MutationInterceptorFactory> findInterceptors() {
        return this.load(MutationInterceptorFactory.class);
    }

    public List<BuildVerifierFactory> findVerifiers() {
        return new ArrayList<BuildVerifierFactory>(this.load(BuildVerifierFactory.class));
    }

    public List<MutationResultInterceptor> findMutationResultInterceptor() {
        return new ArrayList<MutationResultInterceptor>(this.load(MutationResultInterceptor.class));
    }

    public List<CoverageTransformerFactory> findCoverageTransformers() {
        return new ArrayList<CoverageTransformerFactory>(this.load(CoverageTransformerFactory.class));
    }

    public List<CodeSourceFactory> findCodeSources() {
        return new ArrayList<CodeSourceFactory>(this.load(CodeSourceFactory.class));
    }

    public List<HistoryFactory> findHistory() {
        return new ArrayList<HistoryFactory>(this.load(HistoryFactory.class));
    }

    public List<CoverageExporterFactory> findCoverageExport() {
        return new ArrayList<CoverageExporterFactory>(this.load(CoverageExporterFactory.class));
    }

    public List<TestStatListenerFactory> findTestStatListeners() {
        return new ArrayList<TestStatListenerFactory>(this.load(TestStatListenerFactory.class));
    }

    public List<TestFilterFactory> findTestFilters() {
        return new ArrayList<TestFilterFactory>(this.load(TestFilterFactory.class));
    }

    public List<MutatorInfo> findMutatorInfos() {
        List combined = this.findMutationOperators().stream().filter(p -> p instanceof MutatorInfo).map(MutatorInfo.class::cast).collect(Collectors.toList());
        List<MutatorInfo> info = this.findStandAloneMutatorInfos();
        info.addAll(combined);
        return info;
    }

    List<MutatorInfo> findStandAloneMutatorInfos() {
        return new ArrayList<MutatorInfo>(this.load(MutatorInfo.class));
    }

    public Collection<ProvidesFeature> findFeatures() {
        return this.findToolClasspathPlugins().stream().filter(p -> p instanceof ProvidesFeature).map(ProvidesFeature.class::cast).collect(Collectors.toList());
    }

    private <S> Collection<S> load(Class<S> ifc) {
        return this.loader.load(ifc);
    }
}

