/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.tooling.DirectorySourceLocator;
import org.pitest.mutationtest.tooling.PathComparator;
import org.pitest.util.Unchecked;

public class SmartSourceLocator
implements SourceLocator {
    private static final int MAX_DEPTH = 4;
    private final List<SourceLocator> children;
    private final Charset inputCharset;

    public SmartSourceLocator(Collection<Path> roots, Charset inputCharset) {
        this.inputCharset = inputCharset;
        Collection childDirs = roots.stream().flatMap(r -> this.collectDirectories((Path)r, 4).stream()).collect(Collectors.toList());
        childDirs.addAll(roots);
        this.children = childDirs.stream().map(f -> new DirectorySourceLocator((Path)f, this.inputCharset)).collect(Collectors.toList());
    }

    private Collection<Path> collectDirectories(Path root, int depth) {
        Collection collection;
        block9: {
            if (!Files.exists(root, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Stream<Path> matches = Files.find(root, depth, (unused, attributes) -> attributes.isDirectory(), new FileVisitOption[0]);
            try {
                collection = matches.collect(Collectors.toList());
                if (matches == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (matches != null) {
                        try {
                            matches.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw Unchecked.translateCheckedException((Throwable)ex);
                }
            }
            matches.close();
        }
        return collection;
    }

    @Override
    public Optional<Reader> locate(Collection<String> classes, String fileName) {
        for (SourceLocator each : this.children) {
            Optional<Reader> reader = each.locate(classes, fileName);
            if (!reader.isPresent()) continue;
            return reader;
        }
        return Optional.empty();
    }

    public void sourceRootHint(Path file) {
        this.children.sort(new PathComparator(file, File.separator));
    }
}

