/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.util.Unchecked;

public class DirectorySourceLocator
implements SourceLocator {
    private final Path root;
    private final Charset inputCharset;

    public DirectorySourceLocator(Path root, Charset inputCharset) {
        this.root = root;
        this.inputCharset = inputCharset;
    }

    @Override
    public Optional<Reader> locate(Collection<String> classes, String fileName) {
        if (!Files.exists(this.root, new LinkOption[0])) {
            return Optional.empty();
        }
        Optional<Path> path = classes.stream().map(ClassName::fromString).map(ClassName::getPackage).distinct().map(c -> this.toFileName((ClassName)c, fileName)).map(file -> this.root.resolve((String)file)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst();
        if (path.isPresent()) {
            return path.map(this::toReader);
        }
        return this.searchFromRoot(fileName).map(this::toReader);
    }

    public String toString() {
        return this.root.toString();
    }

    private String toFileName(ClassName packge, String fileName) {
        if (packge.asJavaName().equals("")) {
            return fileName;
        }
        return packge.asJavaName().replace(".", File.separator) + File.separator + fileName;
    }

    private Reader toReader(Path path) {
        try {
            return new InputStreamReader((InputStream)new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), this.inputCharset);
        }
        catch (IOException e) {
            throw Unchecked.translateCheckedException((Throwable)e);
        }
    }

    private Optional<Path> searchFromRoot(String fileName) {
        Optional<Path> optional;
        block8: {
            Stream<Path> matches = Files.find(this.root, 100, (path, attributes) -> path.getFileName().toString().equals(fileName) && attributes.isRegularFile(), new FileVisitOption[0]);
            try {
                optional = matches.findFirst();
                if (matches == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (matches != null) {
                        try {
                            matches.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw Unchecked.translateCheckedException((Throwable)e);
                }
            }
            matches.close();
        }
        return optional;
    }
}

