/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.Region;
import org.pitest.mutationtest.build.intercept.RegionIndex;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public abstract class RegionInterceptor
implements MutationInterceptor {
    private ClassTree currentClass;
    private Map<MethodTree, List<RegionIndex>> cache;

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.currentClass = clazz;
        this.cache = new IdentityHashMap<MethodTree, List<RegionIndex>>();
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        return mutations.stream().filter(this.buildPredicate().negate()).collect(Collectors.toList());
    }

    protected Predicate<MutationDetails> buildPredicate() {
        return a -> {
            int instruction = a.getInstructionIndex();
            Optional<MethodTree> method = this.currentClass.method(a.getId().getLocation());
            if (method.isEmpty()) {
                return false;
            }
            List regions = this.cache.computeIfAbsent(method.get(), this::computeRegionIndex);
            return regions.stream().anyMatch(r -> r.start() <= instruction && r.end() >= instruction);
        };
    }

    private List<RegionIndex> computeRegionIndex(MethodTree method) {
        return this.computeRegions(method).stream().map(r -> new RegionIndex(method.instructions().indexOf(r.start), method.instructions().indexOf(r.end))).collect(Collectors.toList());
    }

    protected abstract List<Region> computeRegions(MethodTree var1);

    @Override
    public void end() {
        this.currentClass = null;
        this.cache = null;
    }
}

