/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.groovy;

import java.util.Collection;
import java.util.Collections;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

public class GroovyFilter
implements MutationInterceptor {
    boolean isGroovyClass = false;

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isGroovyClass) {
            return Collections.emptyList();
        }
        return mutations;
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
        this.isGroovyClass = this.isGroovyClass(clazz);
    }

    @Override
    public void end() {
        this.isGroovyClass = false;
    }

    private boolean isGroovyClass(ClassTree clazz) {
        return clazz.rawNode().interfaces != null && clazz.rawNode().interfaces.stream().anyMatch(a -> a.startsWith("groovy/lang/") || a.startsWith("org/codehaus/groovy/runtime"));
    }
}

