/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.ClassFilter;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.PathFilter;
import org.pitest.functional.FCollection;

public class ProjectClassPaths {
    private final ClassPath classPath;
    private final ClassFilter classFilter;
    private final PathFilter pathFilter;

    public ProjectClassPaths(ClassPath classPath, ClassFilter classFilter, PathFilter pathFilter) {
        this.classPath = classPath;
        this.classFilter = classFilter;
        this.pathFilter = pathFilter;
    }

    public Collection<ClassName> code() {
        return FCollection.filter((Iterable)this.classPath.getComponent(this.pathFilter.getCodeFilter()).findClasses(this.classFilter.getCode()), (Predicate)this.classFilter.getCode()).stream().map(ClassName::fromString).collect(Collectors.toList());
    }

    public Collection<ClassName> test() {
        return FCollection.filter((Iterable)this.classPath.getComponent(this.pathFilter.getTestFilter()).findClasses(this.classFilter.getTest()), (Predicate)this.classFilter.getTest()).stream().map(ClassName::fromString).collect(Collectors.toList());
    }

    public ClassPath getClassPath() {
        return this.classPath;
    }

    public ClassFilter getFilter() {
        return this.classFilter;
    }
}

