package org.pitest.mutationtest.build.intercept.lombok;

import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;

public class LombokFilter implements MutationInterceptorFactory {

    @Override
    public String description() {
        return "Lombok junk mutations filter";
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters params) {
        return new LombokNullFilter();
    }

    @Override
    public Feature provides() {
        return Feature.named("lombok")
                .withDescription("Filters out junk mutations generated by lombok")
                .withOnByDefault(true);
    }

}

