/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.incremental;

import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import org.pitest.classinfo.ClassHash;
import org.pitest.classinfo.ClassHashSource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.ClassHistory;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationIdentifier;

class CodeHistory {
    private final ClassHashSource code;
    private final Map<MutationIdentifier, MutationStatusTestPair> previousResults;
    private final Map<ClassName, ClassHistory> previousClassPath;

    CodeHistory(ClassHashSource code, Map<MutationIdentifier, MutationStatusTestPair> previousResults, Map<ClassName, ClassHistory> previousClassPath) {
        this.code = code;
        this.previousResults = previousResults;
        this.previousClassPath = previousClassPath;
    }

    public Optional<MutationStatusTestPair> getPreviousResult(MutationIdentifier id) {
        return Optional.ofNullable(this.previousResults.get(id));
    }

    public boolean hasClassChanged(ClassName className) {
        ClassHistory historic = this.previousClassPath.get(className);
        if (historic == null) {
            return true;
        }
        Optional<ClassHash> current = this.code.fetchClassHash(className);
        return !current.get().getHierarchicalId().equals(historic.getId());
    }

    public boolean hasCoverageChanged(ClassName className, BigInteger currentCoverage) {
        return !this.previousClassPath.get(className).getCoverageId().equals(currentCoverage.toString(16));
    }
}

