/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classpath;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassHash;
import org.pitest.classinfo.ClassName;
import org.pitest.classinfo.Repository;
import org.pitest.classinfo.TestToClassMapper;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.classpath.ProjectClassPaths;

public class DefaultCodeSource
implements CodeSource {
    private final ProjectClassPaths classPath;
    private final Repository classRepository;

    public DefaultCodeSource(ProjectClassPaths classPath) {
        this(classPath, new Repository((ClassByteArraySource)new ClassPathByteArraySource(classPath.getClassPath())));
    }

    public DefaultCodeSource(ProjectClassPaths classPath, Repository classRepository) {
        this.classPath = classPath;
        this.classRepository = classRepository;
    }

    @Override
    public Stream<ClassTree> codeTrees() {
        return this.classPath.code().stream().map(c -> this.getBytes(c.asJavaName())).filter(Optional::isPresent).map(maybe -> ClassTree.fromBytes((byte[])maybe.get()));
    }

    @Override
    public Set<ClassName> getCodeUnderTestNames() {
        return new HashSet<ClassName>(this.classPath.code());
    }

    @Override
    public Set<ClassName> getTestClassNames() {
        return this.classPath.test().stream().collect(Collectors.toSet());
    }

    @Override
    public Stream<ClassTree> testTrees() {
        return this.classPath.test().stream().map(c -> this.getBytes(c.asJavaName())).filter(Optional::isPresent).map(maybe -> ClassTree.fromBytes((byte[])maybe.get())).filter(t -> !t.isAbstract());
    }

    @Override
    public ClassPath getClassPath() {
        return this.classPath.getClassPath();
    }

    @Override
    public Optional<ClassName> findTestee(String className) {
        TestToClassMapper mapper = new TestToClassMapper(this.classRepository);
        return mapper.findTestee(className);
    }

    @Override
    public Collection<ClassHash> fetchClassHashes(Collection<ClassName> classes) {
        return classes.stream().flatMap(c -> this.classRepository.fetchClassHash((ClassName)c).stream()).collect(Collectors.toList());
    }

    @Override
    public Optional<byte[]> fetchClassBytes(ClassName clazz) {
        return this.classRepository.querySource(clazz);
    }

    @Override
    public Optional<ClassHash> fetchClassHash(ClassName clazz) {
        return this.classRepository.fetchClassHash(clazz);
    }

    @Override
    public Optional<byte[]> getBytes(String clazz) {
        return this.fetchClassBytes(ClassName.fromString((String)clazz));
    }
}

