/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.tooling;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.ClassPath;
import org.pitest.classpath.ClassPathByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.classpath.ProjectClassPaths;
import org.pitest.coverage.execute.CoverageOptions;
import org.pitest.coverage.execute.DefaultCoverageGenerator;
import org.pitest.functional.Option;
import org.pitest.functional.SideEffect1;
import org.pitest.mutationtest.MutationResultListenerFactory;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.config.SettingsFactory;
import org.pitest.mutationtest.incremental.WriterFactory;
import org.pitest.mutationtest.incremental.XStreamHistoryStore;
import org.pitest.mutationtest.tooling.AnalysisResult;
import org.pitest.mutationtest.tooling.JarCreatingJarFinder;
import org.pitest.mutationtest.tooling.KnownLocationJavaAgentFinder;
import org.pitest.mutationtest.tooling.MutationCoverage;
import org.pitest.mutationtest.tooling.MutationStrategies;
import org.pitest.plugin.Feature;
import org.pitest.process.LaunchOptions;
import org.pitest.util.Log;
import org.pitest.util.ResultOutputStrategy;
import org.pitest.util.Timings;

public class EntryPoint {
    public AnalysisResult execute(File baseDir, ReportOptions data, PluginServices plugins, Map<String, String> environmentVariables) {
        SettingsFactory settings = new SettingsFactory(data, plugins);
        return this.execute(baseDir, data, settings, environmentVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalysisResult execute(File baseDir, ReportOptions data, SettingsFactory settings, Map<String, String> environmentVariables) {
        if (data.isVerbose()) {
            Log.getLogger().info("---------------------------------------------------------------------------");
            Log.getLogger().info("Enabled (+) and disabled (-) features.");
            Log.getLogger().info("-----------------------------------------");
            settings.describeFeatures(this.asInfo("+"), this.asInfo("-"));
            Log.getLogger().info("---------------------------------------------------------------------------");
        }
        ClassPath cp = data.getClassPath();
        Option<Reader> reader = data.createHistoryReader();
        WriterFactory historyWriter = data.createHistoryWriter();
        JarCreatingJarFinder jac = new JarCreatingJarFinder((ClassByteArraySource)new ClassPathByteArraySource(cp));
        KnownLocationJavaAgentFinder ja = new KnownLocationJavaAgentFinder((String)jac.getJarLocation().value());
        ResultOutputStrategy reportOutput = settings.getOutputStrategy();
        MutationResultListenerFactory reportFactory = settings.createListener();
        CoverageOptions coverageOptions = settings.createCoverageOptions();
        LaunchOptions launchOptions = new LaunchOptions(ja, settings.getJavaExecutable(), data.getJvmArgs(), environmentVariables);
        ProjectClassPaths cps = data.getMutationClassPaths();
        CodeSource code = new CodeSource(cps, coverageOptions.getPitConfig().testClassIdentifier());
        Timings timings = new Timings();
        DefaultCoverageGenerator coverageDatabase = new DefaultCoverageGenerator(baseDir, coverageOptions, launchOptions, code, settings.createCoverageExporter(), timings, !data.isVerbose());
        XStreamHistoryStore history = new XStreamHistoryStore(historyWriter, reader);
        MutationStrategies strategies = new MutationStrategies(settings.createEngine(), history, coverageDatabase, reportFactory, reportOutput);
        MutationCoverage report = new MutationCoverage(strategies, baseDir, code, data, settings, timings);
        try {
            AnalysisResult analysisResult = AnalysisResult.success(report.runReport());
            return analysisResult;
        }
        catch (IOException e) {
            AnalysisResult analysisResult = AnalysisResult.fail(e);
            return analysisResult;
        }
        finally {
            jac.close();
            ja.close();
            historyWriter.close();
        }
    }

    private SideEffect1<Feature> asInfo(final String leader) {
        return new SideEffect1<Feature>(){

            public void apply(Feature a) {
                Log.getLogger().info(String.format("%1$-16s", leader + a.name()) + a.description());
            }
        };
    }
}

