/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.statistics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pitest.functional.F;
import org.pitest.functional.F2;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.statistics.Score;
import org.pitest.mutationtest.statistics.StatusCount;

class ScorePrecursor {
    private final String mutatorName;
    private final Map<DetectionStatus, StatusCount> counts;

    ScorePrecursor(String name) {
        this.mutatorName = name;
        this.counts = ScorePrecursor.createMap();
    }

    void registerResult(DetectionStatus result) {
        StatusCount total = this.counts.get(result);
        total.increment();
    }

    Iterable<StatusCount> getCounts() {
        return this.counts.values();
    }

    private long getTotalMutations() {
        return (Long)FCollection.fold(this.addTotals(), (Object)0L, this.counts.values());
    }

    private long getTotalDetectedMutations() {
        return (Long)FCollection.fold(this.addTotals(), (Object)0L, (Iterable)FCollection.filter(this.counts.values(), ScorePrecursor.isDetected()));
    }

    private static F<StatusCount, Boolean> isDetected() {
        return new F<StatusCount, Boolean>(){

            public Boolean apply(StatusCount a) {
                return a.getStatus().isDetected();
            }
        };
    }

    private F2<Long, StatusCount, Long> addTotals() {
        return new F2<Long, StatusCount, Long>(){

            public Long apply(Long a, StatusCount b) {
                return a + b.getCount();
            }
        };
    }

    private static Map<DetectionStatus, StatusCount> createMap() {
        LinkedHashMap<DetectionStatus, StatusCount> map = new LinkedHashMap<DetectionStatus, StatusCount>();
        for (DetectionStatus each : DetectionStatus.values()) {
            map.put(each, new StatusCount(each, 0L));
        }
        return map;
    }

    Score toScore() {
        return new Score(this.mutatorName, this.getCounts(), this.getTotalMutations(), this.getTotalDetectedMutations());
    }
}

