/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.staticinitializers;

import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.AnalysisFunctions;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.Option;
import org.pitest.functional.predicate.Or;
import org.pitest.functional.predicate.Predicate;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.PoisonStatus;

class StaticInitializerInterceptor
implements MutationInterceptor {
    private static final MethodName CLINIT = MethodName.fromString((String)"<clinit>");
    private Predicate<MutationDetails> isStaticInitCode;

    StaticInitializerInterceptor() {
    }

    @Override
    public void begin(ClassTree clazz) {
        this.analyseClass(clazz);
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isStaticInitCode != null) {
            FunctionalList altered = FCollection.filter(mutations, this.isStaticInitCode).map(this.setStaticInitializerFlag());
            FunctionalList notAltered = FCollection.filter(mutations, (F)Prelude.not(this.isStaticInitCode));
            notAltered.addAll((Collection)altered);
            return notAltered;
        }
        return mutations;
    }

    @Override
    public void end() {
        this.isStaticInitCode = null;
    }

    private void analyseClass(ClassTree tree) {
        Option clinit = tree.methods().findFirst(this.nameEquals(CLINIT.name()));
        if (clinit.hasSome()) {
            FunctionalList selfCalls = ((MethodTree)clinit.value()).instructions().flatMap(this.is(MethodInsnNode.class)).filter(this.calls(tree.name()));
            Or matchingCalls = Prelude.or((Iterable)selfCalls.map(StaticInitializerInterceptor.toPredicate()));
            Or initOnlyMethods = Prelude.or((Iterable)tree.methods().filter(StaticInitializerInterceptor.isPrivateStatic()).filter((F)matchingCalls).map(AnalysisFunctions.matchMutationsInMethod()));
            this.isStaticInitCode = Prelude.or((Predicate[])new Predicate[]{StaticInitializerInterceptor.isInStaticInitializer(), initOnlyMethods});
        }
    }

    private static Predicate<MutationDetails> isInStaticInitializer() {
        return new Predicate<MutationDetails>(){

            public Boolean apply(MutationDetails a) {
                return a.getId().getLocation().getMethodName().equals((Object)CLINIT);
            }
        };
    }

    private static F<MethodTree, Boolean> isPrivateStatic() {
        return new F<MethodTree, Boolean>(){

            public Boolean apply(MethodTree a) {
                return (a.rawNode().access & 8) != 0 && (a.rawNode().access & 2) != 0;
            }
        };
    }

    private static F<MethodInsnNode, Predicate<MethodTree>> toPredicate() {
        return new F<MethodInsnNode, Predicate<MethodTree>>(){

            public Predicate<MethodTree> apply(MethodInsnNode a) {
                return StaticInitializerInterceptor.matchesCall(a);
            }
        };
    }

    private static Predicate<MethodTree> matchesCall(final MethodInsnNode call) {
        return new Predicate<MethodTree>(){

            public Boolean apply(MethodTree a) {
                return a.rawNode().name.equals(call.name) && a.rawNode().desc.equals(call.desc);
            }
        };
    }

    private F<MethodInsnNode, Boolean> calls(final ClassName self) {
        return new F<MethodInsnNode, Boolean>(){

            public Boolean apply(MethodInsnNode a) {
                return a.owner.equals(self.asInternalName());
            }
        };
    }

    private <T extends AbstractInsnNode> F<AbstractInsnNode, Option<T>> is(final Class<T> clazz) {
        return new F<AbstractInsnNode, Option<T>>(){

            public Option<T> apply(AbstractInsnNode a) {
                if (a.getClass().isAssignableFrom(clazz)) {
                    return Option.some((Object)a);
                }
                return Option.none();
            }
        };
    }

    private Predicate<MethodTree> nameEquals(final String name) {
        return new Predicate<MethodTree>(){

            public Boolean apply(MethodTree a) {
                return a.rawNode().name.equals(name);
            }
        };
    }

    private F<MutationDetails, MutationDetails> setStaticInitializerFlag() {
        return new F<MutationDetails, MutationDetails>(){

            public MutationDetails apply(MutationDetails a) {
                return a.withPoisonStatus(PoisonStatus.IS_STATIC_INITIALIZER_CODE);
            }
        };
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.MODIFY;
    }
}

