/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.TestInfo;
import org.pitest.functional.F;
import org.pitest.functional.FCollection;
import org.pitest.functional.FunctionalList;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationAnalyser;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.build.AnalysisPriorityComparator;
import org.pitest.mutationtest.build.KnownStatusMutationTestUnit;
import org.pitest.mutationtest.build.MutationAnalysisUnit;
import org.pitest.mutationtest.build.MutationGrouper;
import org.pitest.mutationtest.build.MutationSource;
import org.pitest.mutationtest.build.MutationTestUnit;
import org.pitest.mutationtest.build.WorkerFactory;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationTestBuilder {
    private final MutationSource mutationSource;
    private final MutationAnalyser analyser;
    private final WorkerFactory workerFactory;
    private final MutationGrouper grouper;

    public MutationTestBuilder(WorkerFactory workerFactory, MutationAnalyser analyser, MutationSource mutationSource, MutationGrouper grouper) {
        this.mutationSource = mutationSource;
        this.analyser = analyser;
        this.workerFactory = workerFactory;
        this.grouper = grouper;
    }

    public List<MutationAnalysisUnit> createMutationTestUnits(Collection<ClassName> codeClasses) {
        ArrayList<MutationAnalysisUnit> tus = new ArrayList<MutationAnalysisUnit>();
        FunctionalList mutations = FCollection.flatMap(codeClasses, this.classToMutations());
        Collections.sort(mutations, this.comparator());
        Collection<MutationResult> analysedMutations = this.analyser.analyse((Collection<MutationDetails>)mutations);
        FunctionalList needAnalysis = FCollection.filter(analysedMutations, MutationTestBuilder.statusNotKnown()).map(MutationTestBuilder.resultToDetails());
        FunctionalList analysed = FCollection.filter(analysedMutations, (F)Prelude.not(MutationTestBuilder.statusNotKnown()));
        if (!analysed.isEmpty()) {
            tus.add(this.makePreAnalysedUnit((List<MutationResult>)analysed));
        }
        if (!needAnalysis.isEmpty()) {
            for (Collection collection : this.grouper.groupMutations(codeClasses, (Collection<MutationDetails>)needAnalysis)) {
                tus.add(this.makeUnanalysedUnit(collection));
            }
        }
        Collections.sort(tus, new AnalysisPriorityComparator());
        return tus;
    }

    private Comparator<MutationDetails> comparator() {
        return new Comparator<MutationDetails>(){

            @Override
            public int compare(MutationDetails arg0, MutationDetails arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        };
    }

    private F<ClassName, Iterable<MutationDetails>> classToMutations() {
        return new F<ClassName, Iterable<MutationDetails>>(){

            public Iterable<MutationDetails> apply(ClassName a) {
                return MutationTestBuilder.this.mutationSource.createMutations(a);
            }
        };
    }

    private MutationAnalysisUnit makePreAnalysedUnit(List<MutationResult> analysed) {
        return new KnownStatusMutationTestUnit(analysed);
    }

    private MutationAnalysisUnit makeUnanalysedUnit(Collection<MutationDetails> needAnalysis) {
        HashSet<ClassName> uniqueTestClasses = new HashSet<ClassName>();
        FCollection.flatMapTo(needAnalysis, MutationTestBuilder.mutationDetailsToTestClass(), uniqueTestClasses);
        return new MutationTestUnit(needAnalysis, uniqueTestClasses, this.workerFactory);
    }

    private static F<MutationResult, MutationDetails> resultToDetails() {
        return new F<MutationResult, MutationDetails>(){

            public MutationDetails apply(MutationResult a) {
                return a.getDetails();
            }
        };
    }

    private static F<MutationResult, Boolean> statusNotKnown() {
        return new F<MutationResult, Boolean>(){

            public Boolean apply(MutationResult a) {
                return a.getStatus() == DetectionStatus.NOT_STARTED;
            }
        };
    }

    private static F<MutationDetails, Iterable<ClassName>> mutationDetailsToTestClass() {
        return new F<MutationDetails, Iterable<ClassName>>(){

            public Iterable<ClassName> apply(MutationDetails a) {
                return FCollection.map((Iterable)a.getTestsInOrder(), (F)TestInfo.toDefiningClassName());
            }
        };
    }
}

