/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.bytecode.analysis;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.F;
import org.pitest.functional.prelude.Prelude;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.SlotRead;
import org.pitest.sequence.SlotWrite;

public class InstructionMatchers {
    public static Match<AbstractInsnNode> anyInstruction() {
        return Match.always();
    }

    public static Match<AbstractInsnNode> opCode(final int opcode) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode a) {
                return a.getOpcode() == opcode;
            }
        };
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> isA(final Class<T> cls) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode a) {
                return a.getClass().isAssignableFrom(cls);
            }
        };
    }

    public static Match<AbstractInsnNode> incrementsVariable(final SlotRead<Integer> counterVariable) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> context, AbstractInsnNode a) {
                return a instanceof IincInsnNode && context.retrieve(counterVariable).contains((F)Prelude.isEqualTo((Object)((IincInsnNode)a).var));
            }
        };
    }

    public static Match<AbstractInsnNode> anIStore(SlotWrite<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.aVariableAccess(counterVariable));
    }

    public static Match<AbstractInsnNode> aVariableAccess(final SlotWrite<Integer> counterVariable) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                return t instanceof VarInsnNode && c.store(counterVariable, (Object)((VarInsnNode)t).var);
            }
        };
    }

    public static Match<AbstractInsnNode> anIStoreTo(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(54).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> anILoadOf(SlotRead<Integer> counterVariable) {
        return InstructionMatchers.opCode(21).and(InstructionMatchers.variableMatches(counterVariable));
    }

    public static Match<AbstractInsnNode> variableMatches(final SlotRead<Integer> counterVariable) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                return t instanceof VarInsnNode && c.retrieve(counterVariable).contains((F)Prelude.isEqualTo((Object)((VarInsnNode)t).var));
            }
        };
    }

    public static Match<AbstractInsnNode> anIntegerConstant() {
        return InstructionMatchers.opCode(2).or(InstructionMatchers.opCode(3)).or(InstructionMatchers.opCode(4)).or(InstructionMatchers.opCode(5)).or(InstructionMatchers.opCode(6)).or(InstructionMatchers.opCode(7)).or(InstructionMatchers.opCode(8));
    }

    public static Match<AbstractInsnNode> aLabelNode(SlotWrite<LabelNode> slot) {
        return InstructionMatchers.isA(LabelNode.class).and(InstructionMatchers.writeNodeToSlot(slot, LabelNode.class));
    }

    public static Match<AbstractInsnNode> aJump() {
        return InstructionMatchers.isA(JumpInsnNode.class);
    }

    public static Match<AbstractInsnNode> aConditionalJump() {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                return t instanceof JumpInsnNode && t.getOpcode() != 167 && t.getOpcode() != 168;
            }
        };
    }

    public static <T extends AbstractInsnNode> Match<AbstractInsnNode> writeNodeToSlot(final SlotWrite<T> slot, final Class<T> clazz) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                if (clazz.isAssignableFrom(t.getClass())) {
                    c.store(slot, clazz.cast(t));
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<AbstractInsnNode> methodCallThatReturns(final ClassName type) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                if (t instanceof MethodInsnNode) {
                    return ((MethodInsnNode)t).desc.endsWith(type.asInternalName() + ";");
                }
                return false;
            }
        };
    }

    public static Match<AbstractInsnNode> methodCall() {
        return InstructionMatchers.isA(MethodInsnNode.class);
    }

    public static Match<AbstractInsnNode> methodCallTo(final ClassName owner, final String name) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                if (t instanceof MethodInsnNode) {
                    MethodInsnNode call = (MethodInsnNode)t;
                    return call.name.equals(name) && call.owner.equals(owner.asInternalName());
                }
                return false;
            }
        };
    }

    private static Match<AbstractInsnNode> storeJumpTarget(final SlotWrite<LabelNode> label) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                if (t instanceof JumpInsnNode) {
                    c.store(label, (Object)((JumpInsnNode)t).label);
                    return true;
                }
                return false;
            }
        };
    }

    public static Match<AbstractInsnNode> jumpsTo(final SlotRead<LabelNode> loopStart) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> context, AbstractInsnNode a) {
                if (!(a instanceof JumpInsnNode)) {
                    return false;
                }
                JumpInsnNode jump = (JumpInsnNode)a;
                return context.retrieve(loopStart).contains((F)Prelude.isEqualTo((Object)jump.label));
            }
        };
    }

    public static Match<AbstractInsnNode> gotoLabel(SlotWrite<LabelNode> loopEnd) {
        return InstructionMatchers.opCode(167).and(InstructionMatchers.storeJumpTarget(loopEnd));
    }

    public static Match<AbstractInsnNode> labelNode(final SlotRead<LabelNode> loopEnd) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode t) {
                if (!(t instanceof LabelNode)) {
                    return false;
                }
                LabelNode l = (LabelNode)t;
                return c.retrieve(loopEnd).contains((F)Prelude.isEqualTo((Object)l));
            }
        };
    }

    public static Match<AbstractInsnNode> debug(final String msg) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> context, AbstractInsnNode a) {
                context.debug(msg);
                return true;
            }
        };
    }
}

