/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.util;

import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.pitest.coverage.TestStatListener;
import org.pitest.util.StringUtil;
import org.pitest.util.TimeSpan;

public class Timings {
    private final TestStatListener testStats;
    private final Map<Stage, TimeSpan> timings = new LinkedHashMap<Stage, TimeSpan>();

    public Timings(TestStatListener testStats) {
        this.testStats = testStats;
    }

    public void registerStart(Stage stage) {
        this.timings.put(stage, new TimeSpan(System.nanoTime(), 0L));
    }

    public void registerEnd(Stage stage) {
        long end = System.nanoTime();
        this.timings.get((Object)stage).setEnd(end);
    }

    public void report(PrintStream ps) {
        long total = 0L;
        for (Map.Entry<Stage, TimeSpan> entry : this.timings.entrySet()) {
            total += entry.getValue().duration();
            ps.println("> " + String.valueOf((Object)entry.getKey()) + " : " + String.valueOf(entry.getValue()));
        }
        ps.println(StringUtil.separatorLine());
        ps.println("> Total  : " + String.valueOf(new TimeSpan(0L, TimeUnit.MILLISECONDS.toNanos(total))));
        ps.println(StringUtil.separatorLine());
        for (String string : this.testStats.messages()) {
            ps.println("> " + string);
        }
    }

    public static enum Stage {
        MUTATION_PRE_SCAN("pre-scan for mutations"),
        BUILD_MUTATION_TESTS("build mutation tests"),
        RUN_MUTATION_TESTS("run mutation analysis"),
        SCAN_CLASS_PATH("scan classpath"),
        COVERAGE("coverage and dependency analysis");

        private final String description;

        private Stage(String desc) {
            this.description = desc;
        }

        public String toString() {
            return this.description;
        }
    }
}

