/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.Objects;
import java.util.Optional;

public final class BuildMessage
implements Comparable<BuildMessage> {
    private final String text;
    private final String url;
    private final int priority;

    public BuildMessage(String text, String url, int priority) {
        this.text = text;
        this.url = url;
        this.priority = priority;
    }

    public static BuildMessage buildMessage(String text) {
        return new BuildMessage(text, null, 5);
    }

    public String text() {
        return this.text;
    }

    public String url() {
        return this.url;
    }

    public int priority() {
        return this.priority;
    }

    public String toString() {
        return this.text + Optional.ofNullable(this.url).map(u -> " (" + u + ")").orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildMessage that = (BuildMessage)o;
        return this.priority == that.priority && Objects.equals(this.text, that.text) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.url, this.priority);
    }

    @Override
    public int compareTo(BuildMessage o) {
        return Integer.compare(this.priority, o.priority);
    }
}

