/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.util.Objects;
import java.util.Set;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.classinfo.ClassName;

public final class ClassLines {
    private final ClassName name;
    private final Set<Integer> codeLines;

    public ClassLines(ClassName name, Set<Integer> codeLines) {
        this.name = name;
        this.codeLines = codeLines;
    }

    public static ClassLines fromTree(ClassTree classTree) {
        return new ClassLines(classTree.name(), classTree.codeLineNumbers());
    }

    public ClassName name() {
        return this.name;
    }

    public int getNumberOfCodeLines() {
        return this.codeLines.size();
    }

    public boolean isCodeLine(int line) {
        return this.codeLines.contains(line);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLines that = (ClassLines)o;
        return this.name.equals((Object)that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

