/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.commandline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class CommaAwareArgsProcessor {
    private static final char REGION_BEGIN = '{';
    private static final char REGION_END = '}';
    private final OptionSpec<String> optionsSpec;

    public CommaAwareArgsProcessor(OptionSpec<String> args) {
        this.optionsSpec = args;
    }

    public List<String> values(OptionSet userArgs) {
        String commandLineOption = this.optionsSpec.value(userArgs);
        if (commandLineOption == null) {
            return Collections.emptyList();
        }
        HashSet<Integer> modifiedIndices = new HashSet<Integer>();
        String preprocessedOptions = this.replaceCommas(commandLineOption, modifiedIndices);
        String[] arguments = preprocessedOptions.split(",");
        return this.postProcess(modifiedIndices, arguments);
    }

    private List<String> postProcess(Set<Integer> modifiedIndices, String[] arguments) {
        ArrayList<String> newArguments = new ArrayList<String>();
        int base = 0;
        for (String argument : arguments) {
            newArguments.add(this.buildNewArgument(modifiedIndices, base, argument).toString());
            base += argument.length() + 1;
        }
        return newArguments;
    }

    private StringBuilder buildNewArgument(Set<Integer> modifiedIndices, int base, String argument) {
        StringBuilder newArgument = new StringBuilder();
        for (int j = 0; j < argument.length(); ++j) {
            char current = argument.charAt(j);
            if (!modifiedIndices.isEmpty() && (current == '{' || current == '}')) continue;
            if (current == '@' && modifiedIndices.contains(j + base)) {
                newArgument.append(',');
                continue;
            }
            newArgument.append(current);
        }
        return newArgument;
    }

    private String replaceCommas(String single, Set<Integer> modifiedIndices) {
        StringBuilder newString = new StringBuilder();
        boolean inSpecialRegion = false;
        for (int i = 0; i < single.length(); ++i) {
            int current;
            int tobeAdded = current = single.charAt(i);
            if (current == 123 && !inSpecialRegion) {
                inSpecialRegion = true;
            } else if (current == 125 && inSpecialRegion) {
                inSpecialRegion = false;
            } else if (inSpecialRegion && current == 44) {
                tobeAdded = 64;
                modifiedIndices.add(i);
            }
            newString.append((char)tobeAdded);
        }
        return newString.toString();
    }
}

